/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.findings.semgrep.SemgrepAnalysisStep;
import com.teamscale.index.findings.semgrep.SemgrepRuleFileLoader;
import com.teamscale.index.findings.semgrep.SemgrepRulesFileReader;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SemgrepConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "semgrep";
    public static final String SEMGREP_MAPPINGS_TSV = "semgrep/check-mappings.tsv";
    private static final Logger LOGGER = LogManager.getLogger();

    public SemgrepConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.SEMGREP, FINDING_CATEGORY, null, SEMGREP_MAPPINGS_TSV, null, "");
        this.declareCodeScopeAware();
    }

    protected Set<ELanguage> determineLanguages(String checkId) {
        return SemgrepConfiguration.determineLanguagesFromGitlabSastRuleId(checkId);
    }

    protected String disambiguateCheckReadableName(String readableCheckName, String checkId) {
        int indexOfFirstDash = checkId.indexOf(45);
        if (indexOfFirstDash != -1) {
            return readableCheckName + " \\(" + checkId.substring(indexOfFirstDash + 1) + "\\)";
        }
        LOGGER.error("Unexpected check id format: {}", (Object)checkId);
        return super.disambiguateCheckReadableName(readableCheckName, checkId);
    }

    public static @NonNull Set<ELanguage> determineLanguagesFromGitlabSastRuleId(String checkId) {
        String normalizedCheckId = StringUtils.stripPrefix((String)checkId, (String)"rules_lgpl_");
        if (normalizedCheckId.startsWith("c_")) {
            return LanguageGroups.C_CPP_AND_MS_CLI;
        }
        if (normalizedCheckId.startsWith("csharp_")) {
            return EnumSet.of(ELanguage.CS);
        }
        if (normalizedCheckId.startsWith("go_")) {
            return EnumSet.of(ELanguage.GO);
        }
        if (normalizedCheckId.startsWith("java_")) {
            return EnumSet.of(ELanguage.JAVA);
        }
        if (normalizedCheckId.startsWith("javascript_")) {
            return EnumSet.of(ELanguage.JAVASCRIPT);
        }
        if (normalizedCheckId.startsWith("kotlin_")) {
            return EnumSet.of(ELanguage.KOTLIN);
        }
        if (normalizedCheckId.startsWith("python_")) {
            return EnumSet.of(ELanguage.PYTHON);
        }
        if (normalizedCheckId.startsWith("swift_")) {
            return EnumSet.of(ELanguage.SWIFT);
        }
        if (normalizedCheckId.startsWith("oc_")) {
            return EnumSet.of(ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP);
        }
        LOGGER.warn("Could not determine language for " + normalizedCheckId + ". Ignoring this check");
        return EnumSet.noneOf(ELanguage.class);
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            SemgrepAnalysisStep.verifySemgrepVersion();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    protected String getDescription(String ruleId, @Nullable String descriptionPath) {
        return SemgrepConfiguration.getDescriptionForGitlabSastRule(ruleId);
    }

    @VisibleForTesting
    public static String getDescriptionForGitlabSastRule(String ruleId) {
        SemgrepRulesFileReader.SemgrepRule rule;
        Optional<Path> resource = SemgrepRuleFileLoader.getRuleFilePath(ruleId);
        if (resource.isEmpty()) {
            LOGGER.error("Could not find semgrep rule file for " + ruleId);
            return "";
        }
        try {
            rule = SemgrepRulesFileReader.getFirstRuleFromFileContent(resource.get());
        }
        catch (IOException e) {
            LOGGER.error("Could not read semgrep rule file for " + ruleId, (Throwable)e);
            return "";
        }
        Optional<URL> gitlabUrl = SemgrepRuleFileLoader.buildGitlabUrlForRuleId(ruleId);
        String description = rule.getMessage() + "\n\n# References\n- Gitlab SAST Rule ID: `" + ruleId + "`";
        if (gitlabUrl.isPresent()) {
            description = description + "\n- " + String.valueOf(gitlabUrl.get());
        }
        return description;
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        SemgrepConfiguration.createTriggers(proxy, (CodeScopeAware<Collection<String>>)activeChecksPerCodeScope);
        super.configureProjectInternal(proxy);
    }

    private static void createTriggers(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) throws ProjectConfigurationException {
        proxy.createTrigger(SemgrepConfiguration.createSemgrepAnalysisStepBuilder(activeChecksPerCodeScope));
    }

    private static TriggerBuilder createSemgrepAnalysisStepBuilder(CodeScopeAware<Collection<String>> activeChecksPerCodeScope) {
        TriggerBuilder triggerBuilder = new TriggerBuilder(SemgrepAnalysisStep.class, ETriggerConcurrency.PARALLEL);
        SemgrepConfiguration.addSemgrepAnalysisStepParameters(triggerBuilder, activeChecksPerCodeScope);
        return triggerBuilder;
    }

    private static void addSemgrepAnalysisStepParameters(TriggerBuilder triggerBuilder, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) {
        triggerBuilder.setTriggerParameter("checks", activeChecksPerCodeScope);
    }
}

