/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.configuration.DataflowAnalysisConfiguration;
import com.teamscale.index.dataflow.CfgConstructorResult;
import com.teamscale.index.dataflow.DataflowConfigurationParameters;
import com.teamscale.index.dataflow.EDataflowAnalysis;
import com.teamscale.index.dataflow.IDataflowAnalysis;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.dataflow.filters.DataflowFalsePositiveFilterFactory;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class DataflowAnalysisRunner {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataflowConfigurationParameters config;
    private final EDataflowAnalysis analysisType;

    public DataflowAnalysisRunner(DataflowConfigurationParameters config, EDataflowAnalysis analysisType) {
        this.config = config;
        this.analysisType = analysisType;
    }

    public ListMap<String, IndexFinding> process(TokenElementInfo element, CfgConstructorResult cfg) {
        if (!DataFlowHeuristicFactory.supportsLanguage(element.getLanguage())) {
            return ListMap.emptyMap();
        }
        if (this.analysisType == EDataflowAnalysis.DIVISION_BY_ZERO && !DataflowAnalysisConfiguration.DIVISION_BY_ZERO_ANALYSIS_ENABLED_LANGUAGES.contains(element.getLanguage())) {
            return ListMap.emptyMap();
        }
        if (cfg == null || cfg.getGraphs() == null) {
            LOGGER.warn("Did not find any control flow graphs on element " + element.getUniformPath() + ". Ignoring this element completely.");
            return ListMap.emptyMap();
        }
        LineOffsetConverter rawLineOffsetConverter = new LineOffsetConverter(element.getText());
        List<IFalsePositiveFilter> filters = DataflowFalsePositiveFilterFactory.createFilters(this.analysisType, element.getLanguage(), this.config);
        ListMap findings = new ListMap();
        for (ControlFlowGraph controlFlowGraph : cfg.getGraphs()) {
            try {
                IDataflowAnalysis analysis = this.analysisType.createAnalysis();
                findings.addAll(analysis.analyze(element, controlFlowGraph, filters, cfg.getEntities(), rawLineOffsetConverter));
            }
            catch (RuntimeException | ConQATException e) {
                LOGGER.error("Data flow analysis " + String.valueOf((Object)this.analysisType) + " failed badly in element " + element.getUniformPath() + ", method " + controlFlowGraph.getMethodName(), e);
            }
        }
        return findings;
    }
}

