/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cs;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeConditionHeuristic;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

public class CsConditionHeuristic
extends CLikeConditionHeuristic {
    private static final TokenPattern NULL_CONDITIONAL_OPERATOR_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.SAFECALL_OPERATOR, ETokenType.IDENTIFIER}).repeated(new Object[]{TokenPattern.of().alternative(new Object[]{TokenPattern.of().sequence(new Object[]{ETokenType.SAFECALL_OPERATOR, ETokenType.IDENTIFIER}), TokenPattern.of().sequence(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})})});
    private static final TokenPattern NULL_CONDITIONAL_BEFORE_EQUALS = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN}).sequence(new Object[]{nullCheckOperators}).alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL});
    private static final TokenPattern NULL_CONDITIONAL_AFTER_EQUALS = TokenPattern.of().sequence(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}).sequence(new Object[]{nullCheckOperators}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN});
    private static final TokenPattern NULL_CONDITIONAL_BEFORE_NOT_EQUALS = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN}).alternative(new Object[]{notNullCheckOperators, TokenPattern.of().sequence(new Object[]{ETokenType.IS, ETokenType.NOT})}).alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL});
    private static final TokenPattern IS_FOLLOWED_BY_RELATIONAL_OPERATOR = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN}).sequence(new Object[]{ETokenType.IS}).alternative(new Object[]{ETokenType.GT, ETokenType.LT, ETokenType.GTEQ, ETokenType.LTEQ}).sequence(new Object[]{ETokenType.INTEGER_LITERAL});
    private static final TokenPattern NULL_CONDITIONAL_WITH_RELATIONAL_OPERATOR = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN}).alternative(new Object[]{ETokenType.GT, ETokenType.LT, ETokenType.GTEQ, ETokenType.LTEQ, ETokenType.EQEQ, ETokenType.NEQ}).alternative(new Object[]{ETokenType.INTEGER_LITERAL, ETokenType.TRUE, ETokenType.FALSE});
    private static final TokenPattern NULL_CONDITIONAL_WITH_RELATIONAL_OPERATOR_REVERSED = TokenPattern.of().alternative(new Object[]{ETokenType.INTEGER_LITERAL, ETokenType.TRUE, ETokenType.FALSE}).alternative(new Object[]{ETokenType.GT, ETokenType.LT, ETokenType.GTEQ, ETokenType.LTEQ, ETokenType.EQEQ, ETokenType.NEQ}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN});
    private static final TokenPattern NULL_CONDITIONAL_AFTER_NOT_EQUALS = TokenPattern.of().alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}).alternative(new Object[]{notNullCheckOperators, TokenPattern.of().sequence(new Object[]{ETokenType.IS, ETokenType.NOT})}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{NULL_CONDITIONAL_OPERATOR_PATTERN});
    private static final TokenPattern NULL_CONDITIONAL_CHECK_PATTERN = TokenPattern.of().alternative(new Object[]{NULL_CONDITIONAL_BEFORE_EQUALS, NULL_CONDITIONAL_AFTER_EQUALS, NULL_CONDITIONAL_BEFORE_NOT_EQUALS, NULL_CONDITIONAL_AFTER_NOT_EQUALS, IS_FOLLOWED_BY_RELATIONAL_OPERATOR, NULL_CONDITIONAL_WITH_RELATIONAL_OPERATOR, NULL_CONDITIONAL_WITH_RELATIONAL_OPERATOR_REVERSED});
    private static final TokenPattern IS_NOT_NULL_CHECK_PATTERN = TokenPattern.of().alternative(new Object[]{TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.IS, ETokenType.NOT}).alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}), TokenPattern.of().alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}).sequence(new Object[]{ETokenType.IS, ETokenType.NOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1)});
    private static final TokenPattern CS_SPECIFIC_NULL_CHECK_PATTERN = TokenPattern.of().alternative(new Object[]{NULL_CONDITIONAL_CHECK_PATTERN, IS_NOT_NULL_CHECK_PATTERN});
    private static final TokenPattern PROPERTY_ACCESS_PATTERN = TokenPattern.of().notPrecededBy((Object)ETokenType.QUESTION).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOT}).notPrecededBy((Object)ETokenType.QUESTION).sequence(new Object[]{ETokenType.IDENTIFIER});

    public CsConditionHeuristic(IDefUseHeuristic defUseHeuristic) {
        super(defUseHeuristic, ETokenType.IS, Set.of(ETokenType.IS), new HashSet<ETokenType>());
    }

    @Override
    protected void addSpecialNullCheckInformation(ConditionTreeNode node, Condition condition) {
        PairList<String, Boolean> relevantBranchInfo;
        String variableName;
        TokenPatternMatch match = CS_SPECIFIC_NULL_CHECK_PATTERN.findFirstMatch(node.getTokens());
        if (match == null) {
            this.processNullConditionalOperators((List<IToken>)node.getTokens(), condition);
            this.processPropertyAccessPatterns((List<IToken>)node.getTokens(), condition);
            return;
        }
        if (match.hasGroup(0)) {
            variableName = match.groupString(0);
            relevantBranchInfo = condition.getNoBranchInfo();
        } else {
            variableName = match.groupString(1);
            relevantBranchInfo = condition.getYesBranchInfo();
        }
        if (this.isUnknown(variableName)) {
            return;
        }
        relevantBranchInfo.add((Object)variableName, (Object)false);
        condition.getNullCheckedVariables().add(variableName);
    }

    private void processNullConditionalOperators(List<IToken> tokens, Condition condition) {
        TokenPattern identifierWithSafecall = TokenPattern.of().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.SAFECALL_OPERATOR});
        identifierWithSafecall.findAll(tokens).stream().map(match -> ((IToken)match.groupTokens(0).getFirst()).getText()).filter((? super T variableName) -> !this.isUnknown((String)variableName)).forEach(variableName -> {
            if (!CsConditionHeuristic.isComparedWithNull(tokens, ETokenType.EQEQ) || CsConditionHeuristic.isComparedWithNull(tokens, ETokenType.NEQ)) {
                condition.getYesBranchInfo().add(variableName, (Object)false);
                condition.getNullCheckedVariables().add((String)variableName);
            }
        });
    }

    private static boolean isComparedWithNull(List<IToken> tokens, ETokenType conjunction) {
        TokenPattern postPattern = TokenPattern.of().sequence(new Object[]{conjunction, ETokenType.NULL_LITERAL});
        TokenPattern prePattern = TokenPattern.of().sequence(new Object[]{ETokenType.NULL_LITERAL, conjunction});
        return postPattern.matchesAnywhere(tokens) || prePattern.matchesAnywhere(tokens);
    }

    private void processPropertyAccessPatterns(List<IToken> tokens, Condition condition) {
        PROPERTY_ACCESS_PATTERN.findAll(tokens).stream().map(match -> ((IToken)match.groupTokens(0).getFirst()).getText()).filter((? super T variableName) -> !this.isUnknown((String)variableName) && !variableName.equals("string") && !variableName.equals("String")).forEach(variableName -> {
            condition.getYesBranchInfo().add(variableName, (Object)false);
            condition.getNoBranchInfo().add(variableName, (Object)false);
        });
    }

    @Override
    protected @NonNull Condition mergeAndCondition(ConditionTreeNode node) {
        List<Condition> childrenConditions = this.createConditions((List<ConditionTreeNode>)node.getChildren());
        Condition mergedCondition = CsConditionHeuristic.merge(childrenConditions);
        CsConditionHeuristic.extractCommonInformation(childrenConditions, mergedCondition.getNoBranchInfo());
        CsConditionHeuristic.removeDuplicateEntries(mergedCondition.getYesBranchInfo());
        return mergedCondition;
    }

    @Override
    protected @NonNull Condition mergeOrCondition(ConditionTreeNode node) {
        List<Condition> childrenConditions = this.createConditions((List<ConditionTreeNode>)node.getChildren());
        Condition mergedCondition = CsConditionHeuristic.merge(childrenConditions);
        CsConditionHeuristic.extractCommonInformation(childrenConditions, mergedCondition.getYesBranchInfo());
        CsConditionHeuristic.removeDuplicateEntries(mergedCondition.getNoBranchInfo());
        return mergedCondition;
    }

    private static void extractCommonInformation(List<Condition> childrenConditions, PairList<String, Boolean> branchInfo) {
        Map<String, Map<Boolean, Long>> counts = branchInfo.stream().collect(Collectors.groupingBy(ImmutablePair::getFirst, Collectors.groupingBy(ImmutablePair::getSecond, Collectors.counting())));
        branchInfo.clear();
        counts.forEach((variableName, valueMap) -> valueMap.forEach((value, count) -> {
            if (count == (long)childrenConditions.size()) {
                branchInfo.add(variableName, value);
            }
        }));
    }

    private static void removeDuplicateEntries(PairList<String, Boolean> branchInfo) {
        Set<Pair> uniqueEntries = branchInfo.stream().collect(Collectors.toSet());
        branchInfo.clear();
        uniqueEntries.forEach(arg_0 -> branchInfo.add(arg_0));
    }

    @Override
    public int getPrecedence(NestingAwareTokenIterator iterator, ConditionTreeNode.EOperator operator, IToken token) {
        if (operator == null || !iterator.isTopLevel() || operator == ConditionTreeNode.EOperator.NOT) {
            return -1;
        }
        if (CsConditionHeuristic.isOrPatternCombinator(operator, token)) {
            return 3;
        }
        if (CsConditionHeuristic.isAndPatternCombinator(operator, token)) {
            return 4;
        }
        if (operator == ConditionTreeNode.EOperator.OR) {
            return 1;
        }
        return 2;
    }

    private static boolean isOrPatternCombinator(ConditionTreeNode.EOperator operator, IToken token) {
        return operator == ConditionTreeNode.EOperator.OR && "or".equals(token.getText());
    }

    private static boolean isAndPatternCombinator(ConditionTreeNode.EOperator operator, IToken token) {
        return operator == ConditionTreeNode.EOperator.AND && "and".equals(token.getText());
    }
}

