/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.java;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.utils.ControlFlowUtils;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.nullpointer.NullPointerFindingsCreationUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.conqat.engine.core.core.ConQATException;

public class FinallyBlockNullPointerFilter
implements IFalsePositiveFilter {
    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        Optional<ShallowEntity> tryBlock = ControlFlowUtils.getEntityOfStatement(controlFlowGraph, statement, "try");
        if (tryBlock.isEmpty()) {
            return false;
        }
        HashSet<ControlFlowNode> seen = new HashSet<ControlFlowNode>();
        Stack<ControlFlowNode> workList = new Stack<ControlFlowNode>();
        workList.add(statement);
        while (!workList.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)workList.pop();
            if (seen.contains(node)) continue;
            seen.add(node);
            workList.addAll(node.getSuccessors());
            Optional<ShallowEntity> finallyBlock = ControlFlowUtils.getEntityOfStatement(controlFlowGraph, node, "finally");
            if (!finallyBlock.isPresent() || !NullPointerFindingsCreationUtils.isNullCheckedIn(node, variable)) continue;
            return true;
        }
        return false;
    }
}

