/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysisglobal;

import com.teamscale.index.dataflow.taintpropagation.analysisglobal.TaintPathsAggregator;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

public class TaintPathsMap {
    private boolean reachedPathsThreshold = false;
    private final HashMap<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>> pathsFromToMap = new HashMap();
    private final HashMap<TaintGraphReferenceBase, Set<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>>> startpointsLookup = new HashMap();
    private final HashSet<TaintGraphReferenceBase> endpointsSet = new HashSet();
    private final int maxPathsBetweenStatements;
    private Map<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>> cleanMapCache;

    public TaintPathsMap(int maxPathsBetweenStatements) {
        this.maxPathsBetweenStatements = maxPathsBetweenStatements;
    }

    private void initializeIfAbsent(Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> pathsKey) {
        this.pathsFromToMap.putIfAbsent((Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>)new Pair(pathsKey), new HashSet());
    }

    public boolean containsKey(Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> pathsKey) {
        return this.pathsFromToMap.containsKey(pathsKey);
    }

    public Map<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>> finalizeAndGetCleanedUnmodifiableMap() {
        if (this.cleanMapCache != null) {
            return this.cleanMapCache;
        }
        Set keyFirsts = this.pathsFromToMap.keySet().stream().map(key -> (TaintGraphReferenceBase)key.getFirst()).collect(Collectors.toSet());
        Set keySeconds = this.pathsFromToMap.keySet().stream().map(key -> (TaintGraphReferenceBase)key.getSecond()).collect(Collectors.toSet());
        HashSet pathStarts = CollectionUtils.differenceSet(keyFirsts, (Collection[])new Collection[]{keySeconds});
        Set<TaintGraphReferenceBase> pathEnds = CollectionUtils.differenceSet(keySeconds, (Collection[])new Collection[]{keyFirsts}).stream().filter(reference -> reference.getType() != TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT).collect(Collectors.toSet());
        HashSet<List<TaintGraphReferenceBase>> completePaths = new HashSet<List<TaintGraphReferenceBase>>();
        for (TaintGraphReferenceBase pathStart : pathStarts) {
            TaintPathsAggregator taintPathsAggregator = new TaintPathsAggregator(this.maxPathsBetweenStatements, this, pathEnds);
            completePaths.addAll(taintPathsAggregator.getCompletePathsFromTo(pathStart));
            this.reachedPathsThreshold |= taintPathsAggregator.reachedPathsThreshold;
        }
        HashMap completePathsMap = new HashMap();
        for (List list : completePaths) {
            completePathsMap.putIfAbsent(new Pair((Object)((TaintGraphReferenceBase)list.get(0)), (Object)((TaintGraphReferenceBase)CollectionUtils.getLast((List)list))), new HashSet());
            ((Set)completePathsMap.get(new Pair((Object)((TaintGraphReferenceBase)list.get(0)), (Object)((TaintGraphReferenceBase)CollectionUtils.getLast((List)list))))).add(list);
        }
        this.cleanMapCache = Collections.unmodifiableMap(completePathsMap);
        return this.cleanMapCache;
    }

    void addPath(Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> key, List<TaintGraphReferenceBase> path) {
        if (this.mapIsFinalized()) {
            throw new IllegalStateException("TaintPathsMap must not be edited after finalization.");
        }
        if (!path.isEmpty()) {
            CCSMAssert.isTrue((!path.get(0).equals(key.getFirst()) ? 1 : 0) != 0, (String)"Illegal path layout.");
            CCSMAssert.isTrue((!((TaintGraphReferenceBase)CollectionUtils.getLast(path)).equals(key.getSecond()) ? 1 : 0) != 0, (String)"Illegal path layout.");
        }
        this.initializeIfAbsent(key);
        if (this.pathsFromToMap.get(key).size() > this.maxPathsBetweenStatements) {
            this.reachedPathsThreshold = true;
            return;
        }
        this.pathsFromToMap.get(key).add(path);
        this.startpointsLookup.computeIfAbsent((TaintGraphReferenceBase)key.getFirst(), start -> new HashSet()).add(key);
        this.endpointsSet.add((TaintGraphReferenceBase)key.getSecond());
    }

    void addPath(TaintGraphReferenceBase from, TaintGraphReferenceBase to, List<TaintGraphReferenceBase> path) {
        this.addPath((Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>)new Pair((Object)from, (Object)to), path);
    }

    public static List<TaintGraphReferenceBase> createPath(TaintGraphReferenceBase node1, List<TaintGraphReferenceBase> tailNodes1, List<TaintGraphReferenceBase> tailNodes2) {
        ArrayList<TaintGraphReferenceBase> extensibleSinkPath = new ArrayList<TaintGraphReferenceBase>();
        extensibleSinkPath.add(node1);
        extensibleSinkPath.addAll(tailNodes1);
        extensibleSinkPath.addAll(tailNodes2);
        return extensibleSinkPath;
    }

    public void printStatistics(PrintStream out) {
        out.println("PathsFromTo statistics: ");
        if (this.pathsFromToMap.isEmpty()) {
            out.println("\tempty");
            return;
        }
        out.println("\t " + this.pathsFromToMap.size() + " key pairs");
        Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> keyForLongestPath = null;
        int longestPath = 0;
        Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> keyForLargestSet = null;
        int largestSetOfPathsForOneKeyPair = 0;
        for (Map.Entry<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>, Set<List<TaintGraphReferenceBase>>> entry : this.pathsFromToMap.entrySet()) {
            Set<List<TaintGraphReferenceBase>> paths = entry.getValue();
            if (paths.size() > largestSetOfPathsForOneKeyPair) {
                largestSetOfPathsForOneKeyPair = paths.size();
                keyForLargestSet = entry.getKey();
            }
            for (List<TaintGraphReferenceBase> path : paths) {
                if (path.size() <= longestPath) continue;
                longestPath = path.size();
                keyForLongestPath = entry.getKey();
            }
        }
        out.println("\tLargest set of paths for one pair: " + largestSetOfPathsForOneKeyPair);
        out.println("\t\tfor pair: " + String.valueOf(keyForLargestSet));
        out.println("\tLongest path: " + longestPath);
        out.println("\t\tfor pair: " + String.valueOf(keyForLongestPath));
    }

    public boolean containsPathsTo(TaintGraphReferenceBase reference) {
        return this.endpointsSet.contains(reference);
    }

    public HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> getInfluenceMap() {
        HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> influenceMap = new HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>();
        for (Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> pathsKey : this.finalizeAndGetCleanedUnmodifiableMap().keySet()) {
            influenceMap.putIfAbsent((TaintGraphReferenceBase)pathsKey.getSecond(), new HashSet());
            influenceMap.get(pathsKey.getSecond()).add((TaintGraphReferenceBase)pathsKey.getFirst());
        }
        return influenceMap;
    }

    public boolean isPathsThresholdReached() {
        return this.reachedPathsThreshold;
    }

    private boolean mapIsFinalized() {
        return this.cleanMapCache != null;
    }

    public Set<List<TaintGraphReferenceBase>> getPathsFromTo(Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> pathKey) {
        return this.pathsFromToMap.get(pathKey);
    }

    public Set<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>> getKeysStartingIn(TaintGraphReferenceBase pathStart) {
        Set<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>> keys = this.startpointsLookup.get(pathStart);
        if (keys == null) {
            return Collections.emptySet();
        }
        return keys;
    }
}

