/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap.ddic;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.abap.AbapDependencyCollection;
import com.teamscale.index.dependencies.abap.ddic.DdicFieldDefinitionStatement;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class AbapDdicDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("(?m)^[^@]*@(.*?)\\s*$");
    private static final Pattern DEFINITION_CONTENT_PATTERN = Pattern.compile("(?s)(?m)^.*define\\s+\\w+\\s+\\S+\\s*\\{(.*)\\}\\s*");
    private static final Pattern DEFINTIION_STATMENT_SPLIT_PATTERN = Pattern.compile("([^;]*);");
    private static final Set<String> BUILT_IN_TYPE_KINDS = new HashSet<String>(Arrays.asList("any", "object", "data", "pre_defined"));
    private AbapDependencyCollection dependencyCollection;
    private String elementText;

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        this.dependencyCollection = new AbapDependencyCollection(this.uniformPath, this.settings, this.typeLookupEnvironment, this.dependencyExtractionIndexes.abapThirdPartyPathsIndex);
        this.elementText = tokenElementInfo.getText();
        UniqueAbapElementName ownElementName = AbapUtils.createElementNameFromPath((String)this.uniformPath);
        List<DdicFieldDefinitionStatement> definitionStatements = this.parseDdicSource();
        switch (ownElementName.getObjectType()) {
            case TABL: 
            case STRU: {
                this.extractDependenciesFromTableOrStructure(definitionStatements);
                break;
            }
            case DOMA: {
                this.extractDependenciesFromDomain(definitionStatements);
                break;
            }
            case DTEL: {
                this.extractDependencyFromDataElementsOrRowTypes(definitionStatements, "type");
                break;
            }
            case TTYP: {
                this.extractDependencyFromDataElementsOrRowTypes(definitionStatements, "row_type");
                break;
            }
            case VIEW: {
                this.extractDependencyFromViews(definitionStatements);
                break;
            }
        }
        return Collections.singletonList(new TypeDependencies(ownElementName.getUniqueName(), this.dependencyCollection.getDependencies()));
    }

    private List<DdicFieldDefinitionStatement> parseDdicSource() {
        ArrayList<DdicFieldDefinitionStatement> definitionStatements = new ArrayList<DdicFieldDefinitionStatement>();
        String filteredText = AbapDdicDependencyExtractor.filterAnnotations(this.elementText);
        Matcher m = DEFINITION_CONTENT_PATTERN.matcher(filteredText);
        if (!m.matches()) {
            LOGGER.warn(this.uniformPath + " is not a ABAP DDIC content.");
            return definitionStatements;
        }
        String content = m.group(1);
        int contentOffset = m.start(1);
        m = DEFINTIION_STATMENT_SPLIT_PATTERN.matcher(content);
        while (m.find()) {
            definitionStatements.add(new DdicFieldDefinitionStatement(this.uniformPath, filteredText, m.start(1) + contentOffset, m.end(1) + contentOffset));
        }
        return definitionStatements;
    }

    static String filterAnnotations(String unfilteredText) {
        Matcher matcher = ANNOTATION_PATTERN.matcher(unfilteredText);
        StringBuilder filteredText = new StringBuilder();
        int currentOffset = 0;
        while (matcher.find()) {
            filteredText.append(unfilteredText.substring(currentOffset, matcher.start(1)));
            filteredText.append(StringUtils.fillString((int)matcher.group(1).length(), (char)'_'));
            currentOffset = matcher.end(1);
        }
        filteredText.append(unfilteredText.substring(currentOffset));
        return filteredText.toString();
    }

    private void extractDependencyFromViews(List<DdicFieldDefinitionStatement> definitionStatements) throws StorageException {
        for (DdicFieldDefinitionStatement fieldDefinitionStatement : definitionStatements) {
            if (!"table".equals(fieldDefinitionStatement.getFieldName())) continue;
            this.addDependency(fieldDefinitionStatement.getAssignedType(), EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
        }
    }

    private void extractDependencyFromDataElementsOrRowTypes(List<DdicFieldDefinitionStatement> definitionStatements, String typeFieldName) throws StorageException {
        String kind = null;
        TextRegionLocation typeLocation = null;
        for (DdicFieldDefinitionStatement fieldDefinitionStatement : definitionStatements) {
            if ("kind".equals(fieldDefinitionStatement.getFieldName())) {
                kind = this.getTextAtRegion(fieldDefinitionStatement.getAssignedType());
            }
            if (!typeFieldName.equals(fieldDefinitionStatement.getFieldName())) continue;
            typeLocation = fieldDefinitionStatement.getAssignedType();
        }
        if (kind == null || BUILT_IN_TYPE_KINDS.contains(kind)) {
            return;
        }
        if (EAbapObjectType.DOMA.name().equalsIgnoreCase(kind)) {
            this.addDependency(typeLocation, EnumSet.of(EAbapObjectType.DOMA));
        } else {
            this.addDependency(typeLocation, EAbapObjectType.ALL_DDIC_DATA_TYPES);
        }
    }

    private void extractDependenciesFromTableOrStructure(List<DdicFieldDefinitionStatement> definitionStatements) throws StorageException {
        for (DdicFieldDefinitionStatement definitionStatement : definitionStatements) {
            this.addDependency(definitionStatement.getAssignedType(), EAbapObjectType.ALL_DDIC_DATA_TYPES);
            this.addDependency(definitionStatement.getForeignKeyTable(), EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
        }
    }

    private void extractDependenciesFromDomain(List<DdicFieldDefinitionStatement> definitionStatements) throws StorageException {
        for (DdicFieldDefinitionStatement fieldDefinitionStatement : definitionStatements) {
            if (!"value_table".equals(fieldDefinitionStatement.getFieldName())) continue;
            this.addDependency(fieldDefinitionStatement.getAssignedType(), EAbapObjectType.ALL_DATABASE_ENTITY_TYPES);
            return;
        }
    }

    private void addDependency(TextRegionLocation typeLocation, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        if (typeLocation == null) {
            return;
        }
        String dependencyText = this.getTextAtRegion(typeLocation);
        if (!AbapDdicDependencyExtractor.isAbapBuiltInType(dependencyText)) {
            this.dependencyCollection.addDependency(dependencyText, typeLocation, possibleObjectTypes);
        }
    }

    private static boolean isAbapBuiltInType(String dependencyText) {
        return dependencyText.toUpperCase().startsWith("ABAP.");
    }

    private String getTextAtRegion(TextRegionLocation location) {
        return this.elementText.substring(location.getRawStartOffset(), location.getRawEndOffset());
    }
}

