/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.teamscale.commons.lang.ToStringHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class TypescriptPathMappings {
    private final PairList<Pattern, String> mappings = new PairList();

    public void addMapping(String pathPrefix, String resolvedPath) {
        this.mappings.add((Object)TypescriptPathMappings.convertPathPrefixToPattern(pathPrefix), (Object)TypescriptPathMappings.convertPathToReplacementString(resolvedPath));
    }

    private static Pattern convertPathPrefixToPattern(String pathPrefix) {
        if (!pathPrefix.endsWith("*")) {
            return Pattern.compile(Pattern.quote(pathPrefix));
        }
        pathPrefix = StringUtils.stripSuffix((String)pathPrefix, (String)"*");
        return Pattern.compile(Pattern.quote(pathPrefix) + "(.*)");
    }

    private static String convertPathToReplacementString(String path) {
        if (!path.endsWith("*")) {
            return Matcher.quoteReplacement(path);
        }
        path = StringUtils.stripSuffix((String)path, (String)"*");
        return Matcher.quoteReplacement(path) + "$1";
    }

    public List<String> resolvePathPrefix(String importString) {
        ArrayList<String> potentialResolvedPaths = new ArrayList<String>();
        for (Pair mapping : this.mappings) {
            Pattern aliasPattern = (Pattern)mapping.getFirst();
            Matcher matcher = aliasPattern.matcher(importString);
            if (!matcher.find()) continue;
            potentialResolvedPaths.add(matcher.replaceFirst((String)mapping.getSecond()));
        }
        return potentialResolvedPaths;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

