/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.teamscale.index.external.status.EExternalAnalysisResultType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="external-analysis-partitions", options={EStorageOption.COMMIT_ISOLATED})
public class ExternalAnalysisPartitionIndex
implements IProjectIndex,
IRollbackableIndex {
    private static final String KEY_SEPARATOR = "#!#";
    private static final String COVERAGE_UPLOADS_PARTITIONS_KEY_PREFIX = "coverage:";
    private static final String TEST_RESULTS_UPLOADS_PARTITIONS_KEY_PREFIX = "test-results:";
    private static final String ALL_UPLOAD_TYPES_PARTITIONS_KEY_PREFIX = "all:";
    private final ValueIndex<Long> delegate;

    public ExternalAnalysisPartitionIndex(IStore store) {
        this.delegate = ValueIndex.forLong((IStore)store);
    }

    public List<String> getAllPartitions() throws StorageException {
        return this.getPartitionsForKey(ALL_UPLOAD_TYPES_PARTITIONS_KEY_PREFIX);
    }

    public List<String> getCoveragePartitions() throws StorageException {
        return this.getPartitionsForKey(COVERAGE_UPLOADS_PARTITIONS_KEY_PREFIX);
    }

    public List<String> getTestResultPartitions() throws StorageException {
        return this.getPartitionsForKey(TEST_RESULTS_UPLOADS_PARTITIONS_KEY_PREFIX);
    }

    private List<String> getPartitionsForKey(String keyPrefix) throws StorageException {
        HashSet<String> partitions = new HashSet<String>();
        List keys = this.delegate.getKeysStartingWith(keyPrefix);
        for (String key : keys) {
            partitions.add(StringUtils.stripPrefix((String)key, (String)keyPrefix).split(KEY_SEPARATOR)[0]);
        }
        return CollectionUtils.sort(partitions);
    }

    public void addPartition(String partition, CommitDescriptor commit, Set<EExternalAnalysisResultType> uploadTypes) throws StorageException {
        this.storePartition(ALL_UPLOAD_TYPES_PARTITIONS_KEY_PREFIX, partition, commit);
        if (CollectionUtils.anyMatch(EExternalAnalysisResultType.TEST_COVERAGE_UPLOAD_TYPES, uploadTypes::contains)) {
            this.storePartition(COVERAGE_UPLOADS_PARTITIONS_KEY_PREFIX, partition, commit);
        }
        if (uploadTypes.contains((Object)EExternalAnalysisResultType.TEST_RESULTS)) {
            this.storePartition(TEST_RESULTS_UPLOADS_PARTITIONS_KEY_PREFIX, partition, commit);
        }
    }

    private void storePartition(String keyPrefix, String partition, CommitDescriptor commit) throws StorageException {
        this.setValueIfUnset(ExternalAnalysisPartitionIndex.makeKey(keyPrefix, partition, commit.getBranchName()), commit.getTimestamp());
    }

    private void setValueIfUnset(String key, long timestamp) throws StorageException {
        Long value = (Long)this.delegate.getValue(key);
        if (value == null || timestamp < value) {
            this.delegate.setValue(key, (Object)timestamp);
        }
    }

    private static String makeKey(String keyPrefix, String partition, String branch) {
        return keyPrefix + partition + KEY_SEPARATOR + branch;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        ArrayList<String> keysToCheckForDeletion = new ArrayList<String>();
        for (String key : this.delegate.getAllKeys()) {
            String branch = ExternalAnalysisPartitionIndex.removePrefix(key).split(KEY_SEPARATOR)[1];
            Long rollbackTimestamp = timestampByBranch.get(branch);
            if (rollbackTimestamp == null) continue;
            keysToCheckForDeletion.add(key);
        }
        List values = this.delegate.getValues(keysToCheckForDeletion);
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (int i = 0; i < keysToCheckForDeletion.size(); ++i) {
            Long timestamp = (Long)values.get(i);
            String branch = ExternalAnalysisPartitionIndex.removePrefix((String)keysToCheckForDeletion.get(i)).split(KEY_SEPARATOR)[1];
            if (timestampByBranch.get(branch) >= timestamp) continue;
            keysToDelete.add((String)keysToCheckForDeletion.get(i));
        }
        this.delegate.removeValues(keysToDelete);
    }

    private static String removePrefix(String key) {
        String keyWithoutPrefix = StringUtils.stripPrefix((String)key, (String)ALL_UPLOAD_TYPES_PARTITIONS_KEY_PREFIX);
        return StringUtils.stripPrefix((String)keyWithoutPrefix, (String)COVERAGE_UPLOADS_PARTITIONS_KEY_PREFIX);
    }
}

