/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.configuration.service.AnalysisProfileUsageInfoWithProjects;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.resource.element_details.PrependDirectivesDetail;
import com.teamscale.index.upload.IExternalToolRule;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class AnalysisProfileUpdater {
    private final IndexLayer indexLayer;
    private final ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex;

    public AnalysisProfileUpdater(IndexLayer indexLayer) throws StorageException {
        this.externalFindingsGroupDescriptionIndex = (ExternalFindingsGroupDescriptionIndex)indexLayer.openGlobalStorageSystem().openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        this.indexLayer = indexLayer;
    }

    public void updateAnalysisProfiles(EAnalysisTool tool, Collection<IExternalToolRule> rules, List<AnalysisProfile> profiles) throws ProjectConfigurationException {
        try {
            Set<IExternalToolRule> addedRules = this.registerFindingDescriptions(rules, tool);
            if (addedRules.isEmpty()) {
                return;
            }
            this.updateAnalysisProfiles(tool, profiles, addedRules);
        }
        catch (ProjectConfigurationException | IOException | ConQATException e) {
            throw new ProjectConfigurationException(e);
        }
    }

    public static void updateFindingsSchema(IProjectId projectId, @Nullable String analysisProfileName, AnalysisProfileIndex analysisProfileIndex1, IndexLayer indexLayer) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        if (analysisProfileName != null) {
            AnalysisProfileUpdater.updateFindingsSchemaForAnalysisProfile(analysisProfileIndex1, indexLayer.openGlobalStorageSystem(), analysisProfileName, projectMetaIndex, projectConfiguration, (ProjectStorageSystem)projectStorageSystem);
        } else {
            for (CodeScope codeScope : projectConfiguration.getCodeScopes()) {
                AnalysisProfile embeddedProfile = codeScope.getEmbeddedProfile();
                CCSMAssert.isNotNull((Object)embeddedProfile, (String)"expected embedded profile to exist when updating the findings schema");
                AnalysisProfileUpdater.updateFindingsSchemaForAnalysisProfile(analysisProfileIndex1, indexLayer.openGlobalStorageSystem(), embeddedProfile.getName(), projectMetaIndex, projectConfiguration, (ProjectStorageSystem)projectStorageSystem);
            }
        }
    }

    private void updateAnalysisProfiles(EAnalysisTool tool, List<AnalysisProfile> profiles, Set<IExternalToolRule> addedRules) throws IOException, ConQATException, ProjectConfigurationException {
        ListMap<String, ExternalAnalysisGroup> externalAnalysisGroup = this.createExternalAnalysisGroupIfNotExists(addedRules, tool);
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)this.indexLayer.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)this.indexLayer.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        for (AnalysisProfile analysisProfile : profiles) {
            this.updateAnalysisGroups(analysisProfile, externalAnalysisGroup);
            AnalysisProfileUtils.addNewAnalysisProfileVersion(analysisProfileVersionedIndex, analysisProfileIndex, analysisProfile, "[System]", "Profile updated by System", this.indexLayer.openGlobalStorageSystem());
            AnalysisProfileUtils.updateCurrentProfileSilently(analysisProfileVersionedIndex, analysisProfileIndex, analysisProfile);
            this.updateReferencingProjects(analysisProfile.getName(), analysisProfileIndex);
        }
    }

    private void updateAnalysisGroups(AnalysisProfile analysisProfile, ListMap<String, ExternalAnalysisGroup> externalAnalysisGroup) throws StorageException, ProjectConfigurationException {
        ConfigurationTemplate template = AnalysisProfileUtils.getTemplateForProfile(analysisProfile, this.indexLayer.openGlobalStorageSystem());
        for (Map.Entry entry : externalAnalysisGroup.entrySet()) {
            QualityIndicator qualityIndicator = analysisProfile.getQualityIndicators().stream().filter(q -> q.getName().equals(entry.getKey())).findAny().orElse(null);
            if (qualityIndicator == null) {
                qualityIndicator = new QualityIndicator((String)entry.getKey());
                analysisProfile.addQualityIndicator(qualityIndicator);
            }
            for (ExternalAnalysisGroup analysisGroup : (List)entry.getValue()) {
                String analysisGroupName = analysisGroup.getGroupName();
                AnalysisGroupDescriptor analysisGroupDescriptor = template.getAnalysisGroup(analysisGroupName);
                if (analysisGroupDescriptor == null) {
                    analysisGroupDescriptor = new AnalysisGroupDescriptor(analysisGroupName, new ConfigurationItemBase[0]);
                    template.registerAnalysisGroup(analysisGroupDescriptor);
                }
                AnalysisProfileUpdater.addRulesToAnalysisGroup(analysisProfile, analysisGroupName, analysisGroupDescriptor, (String)entry.getKey());
            }
        }
    }

    private ListMap<String, ExternalAnalysisGroup> createExternalAnalysisGroupIfNotExists(Collection<IExternalToolRule> rules, EAnalysisTool tool) throws IOException, ConQATException {
        List<ExternalAnalysisGroup> allGroups = this.externalFindingsGroupDescriptionIndex.getGroups(tool);
        ListMap newGroupsByQualityIndicator = new ListMap();
        Map<String, List<IExternalToolRule>> valuesByGroup = rules.stream().collect(Collectors.groupingBy(IExternalToolRule::getAnalysisGroup));
        for (Map.Entry<String, List<IExternalToolRule>> entry : valuesByGroup.entrySet()) {
            ExternalAnalysisGroup newGroup;
            String analysisGroupName = entry.getKey();
            List<IExternalToolRule> rulesInAnalysisGroup = entry.getValue();
            Optional<ExternalAnalysisGroup> optionalGroup = allGroups.stream().filter(g -> g.getGroupName().equals(analysisGroupName)).findFirst();
            String joinedIds = rulesInAnalysisGroup.stream().map(IExternalToolRule::getId).collect(Collectors.joining("|"));
            if (optionalGroup.isEmpty()) {
                newGroup = new ExternalAnalysisGroup(analysisGroupName, joinedIds);
            } else {
                Object newMapping = optionalGroup.get().getMapping();
                newMapping = (String)newMapping + "|" + joinedIds;
                newGroup = new ExternalAnalysisGroup(analysisGroupName, (String)newMapping);
            }
            Set qualityIndicators = rulesInAnalysisGroup.stream().map(IExternalToolRule::getQualityIndicator).collect(Collectors.toSet());
            CCSMAssert.isTrue((qualityIndicators.size() == 1 ? 1 : 0) != 0, (String)"All rules with the same analysis group must have the same quality indicator");
            String qualityIndicator = (String)qualityIndicators.iterator().next();
            newGroupsByQualityIndicator.add((Object)qualityIndicator, (Object)newGroup);
        }
        this.externalFindingsGroupDescriptionIndex.storeGroups((List)newGroupsByQualityIndicator.getValues(), tool);
        return newGroupsByQualityIndicator;
    }

    private Set<IExternalToolRule> registerFindingDescriptions(Collection<IExternalToolRule> rules, EAnalysisTool tool) throws IOException, ConQATException {
        HashMap<String, ExternalFindingsDescription> descriptions = new HashMap<String, ExternalFindingsDescription>();
        for (ExternalFindingsDescription externalFindingsDescription : this.externalFindingsGroupDescriptionIndex.getDescriptions(tool)) {
            descriptions.put(externalFindingsDescription.getTypeId(), externalFindingsDescription);
        }
        HashSet<IExternalToolRule> addedRuleIds = new HashSet<IExternalToolRule>();
        for (IExternalToolRule rule : rules) {
            String ruleId = rule.getId();
            if (!descriptions.containsKey(ruleId)) {
                addedRuleIds.add(rule);
            }
            ExternalFindingsDescription description = new ExternalFindingsDescription(ruleId, rule.getReadableName(), StringUtils.emptyIfNull((String)rule.getFullDescription()), rule.getFindingEnablement());
            descriptions.put(ruleId, description);
        }
        this.externalFindingsGroupDescriptionIndex.storeDescriptions(new ArrayList<ExternalFindingsDescription>(descriptions.values()), tool);
        return addedRuleIds;
    }

    private static void addRulesToAnalysisGroup(AnalysisProfile analysisProfile, String analysisGroupName, AnalysisGroupDescriptor analysisGroupDescriptor, String qualityIndicator) {
        AnalysisGroup analysisGroup = AnalysisProfileUpdater.getOrCreateAnalysisGroup(analysisProfile, analysisGroupName, qualityIndicator);
        for (ConfigurationItemBase configItem : analysisGroupDescriptor.getConfigurationItems()) {
            if (!(configItem instanceof FindingDescriptor) || analysisGroup.getOptionValue(configItem.getName()) != null) continue;
            analysisGroup.setOptionValue(configItem.getName(), ((FindingDescriptor)configItem).getEnablement().toString());
        }
    }

    private static AnalysisGroup getOrCreateAnalysisGroup(AnalysisProfile analysisProfile, String analysisGroupName, String qualityIndicator) {
        AnalysisGroup analysisGroup = AnalysisProfileUtils.getAnalysisGroup(analysisProfile, analysisGroupName);
        if (analysisGroup == null) {
            Optional<QualityIndicator> codeAnomaliesQualityIndicator = analysisProfile.getQualityIndicators().stream().filter(q -> qualityIndicator.equals(q.getName())).findFirst();
            if (codeAnomaliesQualityIndicator.isEmpty()) {
                codeAnomaliesQualityIndicator = Optional.of(new QualityIndicator("Code Anomalies"));
            }
            analysisGroup = new AnalysisGroup(analysisGroupName);
            codeAnomaliesQualityIndicator.get().addGroup(analysisGroup);
        }
        return analysisGroup;
    }

    private void updateReferencingProjects(String analysisProfileName, AnalysisProfileIndex analysisProfileIndex1) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.indexLayer.openGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        Map<String, AnalysisProfileUsageInfoWithProjects> projectsByProfile = AnalysisProfileUpdater.getProjectsByProfile(projectIndex, this.indexLayer);
        if (!projectsByProfile.containsKey(analysisProfileName)) {
            return;
        }
        for (PublicProjectId projectId : projectsByProfile.get(analysisProfileName).getCodeScopesByReferencedProjectIds().getKeys()) {
            AnalysisProfileUpdater.updateFindingsSchema((IProjectId)projectId, analysisProfileName, analysisProfileIndex1, this.indexLayer);
        }
    }

    private static Map<String, AnalysisProfileUsageInfoWithProjects> getProjectsByProfile(ProjectIndex projectIndex, IndexLayer indexLayer) throws StorageException {
        HashMap<String, AnalysisProfileUsageInfoWithProjects> projectsUsingProfile = new HashMap<String, AnalysisProfileUsageInfoWithProjects>();
        List projectInfos = projectIndex.getAllProjectInfos();
        List projectIds = CollectionUtils.map((Collection)projectInfos, ProjectInfo::getPrimaryPublicId);
        for (int i = 0; i < projectIds.size(); ++i) {
            AnalysisProfileUtils.getProfileUsageInfoForProject((PublicProjectId)projectIds.get(i), (ProjectInfo)projectInfos.get(i), null, false, indexLayer, projectsUsingProfile);
        }
        return projectsUsingProfile;
    }

    private static void updateFindingsSchemaForAnalysisProfile(AnalysisProfileIndex analysisProfileIndex, GlobalStorageSystem globalStorageSystem, String analysisProfileName, MetaIndex projectMetaIndex, ProjectConfiguration projectConfiguration, ProjectStorageSystem projectStorageSystem) throws StorageException {
        AnalysisProfile profile = AnalysisProfileUtils.updateAnalysisProfile(analysisProfileIndex, projectMetaIndex, projectConfiguration, analysisProfileName);
        try {
            IndexLayer dummyIndexLayer = ProjectValidationUtils.createDummyProject(List.of(profile), null, globalStorageSystem, true);
            ProjectStorageSystem dummyProjectPartition = ProjectValidationUtils.getDummyProjectPartition(dummyIndexLayer);
            AnalysisProfileUpdater.copyProjectInfos(projectStorageSystem, dummyProjectPartition, projectConfiguration.getCodeScopeNamesForAnalysisProfile(profile.getName()));
        }
        catch (ProjectConfigurationException | TriggerCompilationException e) {
            throw new InternalServerErrorException("Could not create a dummy project to update findings schema.", e);
        }
    }

    private static void copyProjectInfos(ProjectStorageSystem projectStorageSystem, ProjectStorageSystem dummyProjectPartition, List<CodeScopeName> codeScopeNames) throws StorageException {
        FindingsSchemaIndex dummyFindingSchemaIndex = (FindingsSchemaIndex)dummyProjectPartition.openProjectIndex(FindingsSchemaIndex.class, null);
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        MetaIndex dummyMetaIndex = (MetaIndex)dummyProjectPartition.openProjectIndex(MetaIndex.class, null);
        metaIndex.setValue((MetaIndex.IMetaIndexEntry)((PrependDirectivesDetail)dummyMetaIndex.getValue(PrependDirectivesDetail.class)), PrependDirectivesDetail.class);
        FindingsSchemaIndex findingSchemaIndex = (FindingsSchemaIndex)projectStorageSystem.openProjectIndex(FindingsSchemaIndex.class, null);
        for (CodeScopeName codeScopeName : codeScopeNames) {
            FindingsSchema findingsSchema = dummyFindingSchemaIndex.getFindingsSchema(CodeScopeName.DEFAULT);
            findingSchemaIndex.setFindingsSchema(findingsSchema, codeScopeName);
            findingSchemaIndex.setFindingTypeDescriptions(codeScopeName, dummyFindingSchemaIndex.getCodeScopeSpecificFindingTypeDescriptions(CodeScopeName.DEFAULT));
        }
    }
}

