/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.upload_sessions;

import com.google.common.collect.Iterables;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.ScatteredCollectionIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Index(name="external-analysis-session", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.BACKUP}, valueClasses={ExternalAnalysisSessionInfo.class, ExternalAnalysisImportInfo.class})
public class ExternalAnalysisImportSessionIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "external-analysis-session";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BATCH_SIZE = 10;
    private static final String SESSION_ID_DELIMITER = "#";
    private final SimpleCrudIndex<CommitDescriptor, String> commitIndex;
    private final SimpleCrudIndex<String, ExternalAnalysisSessionInfo> sessionIndex;
    private final Function<String, ScatteredCollectionIndex<ExternalAnalysisImportInfo<?>>> valueIndexProvider;
    private final KeysOnlyIndex unscheduledSessionIndex;

    public ExternalAnalysisImportSessionIndex(IStore store) {
        this.commitIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "c"), ISerializer.of(CommitDescriptor::toBranchTimestampKey, CommitDescriptor::fromBranchTimestampKey), ISerializer.forString());
        this.sessionIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "s"), ISerializer.forString(), ISerializer.forSerializable());
        this.valueIndexProvider = sessionId -> ScatteredCollectionIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "v" + sessionId), (int)10);
        this.unscheduledSessionIndex = new KeysOnlyIndex((IStore)new DelegatingPartitionStore(store, "u"));
    }

    private Set<String> getSessionIdsByCommit(CommitDescriptor commit) throws StorageException {
        HashSet<String> sessionIds = new HashSet<String>();
        Optional sessionIdsSerializedOptional = this.commitIndex.get((Object)commit);
        if (sessionIdsSerializedOptional.isEmpty()) {
            return sessionIds;
        }
        String sessionIdsSerialized = (String)sessionIdsSerializedOptional.get();
        return new HashSet<String>(ExternalAnalysisImportSessionIndex.splitRawSessionIds(sessionIdsSerialized));
    }

    public Optional<String> getSessionIdByCommit(CommitDescriptor commit) throws StorageException {
        Set<String> sessionIds = this.getSessionIdsByCommit(commit);
        if (sessionIds.isEmpty()) {
            return Optional.empty();
        }
        if (sessionIds.size() > 1) {
            throw new StorageException("Duplicate session for commit " + String.valueOf(commit) + ": " + String.valueOf(sessionIds));
        }
        return Optional.of((String)Iterables.getOnlyElement(sessionIds));
    }

    public SetMap<CommitDescriptor, String> getSessionIdsByCommits(Collection<CommitDescriptor> commits) throws StorageException {
        SetMap sessionIdsByCommits = new SetMap();
        for (CommitDescriptor commit : commits) {
            sessionIdsByCommits.addAll((Object)commit, this.getSessionIdsByCommit(commit));
        }
        return sessionIdsByCommits;
    }

    private static List<String> splitRawSessionIds(String rawSessionIds) {
        return Arrays.asList(rawSessionIds.split(SESSION_ID_DELIMITER));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Set<String> getSessionIdsForCommits(SequencedCollection<CommitDescriptor> commits) throws StorageException {
        HashSet<String> sessionIds = new HashSet<String>();
        @Nullable List rawSessionIds = this.commitIndex.get(commits);
        for (String rawSessionId : rawSessionIds) {
            if (rawSessionId == null) continue;
            sessionIds.addAll(ExternalAnalysisImportSessionIndex.splitRawSessionIds(rawSessionId));
        }
        return sessionIds;
    }

    boolean hasDataForCommit(CommitDescriptor commit) throws StorageException {
        return this.commitIndex.has((Object)commit);
    }

    void storeSessionInfo(ExternalAnalysisSessionInfo sessionInfo) throws StorageException {
        this.setSessionInfo(sessionInfo.getSessionId(), sessionInfo);
    }

    private void removeCommitToSessionMapping(CommitDescriptor commit, String sessionId) throws StorageException {
        Optional existingSessionId = this.commitIndex.get((Object)commit);
        if (existingSessionId.isEmpty()) {
            return;
        }
        Set<String> storedSessionIds = this.getSessionIdsByCommit(commit);
        storedSessionIds.remove(sessionId);
        this.commitIndex.put((Object)commit, (Object)String.join((CharSequence)SESSION_ID_DELIMITER, storedSessionIds));
    }

    public Optional<ExternalAnalysisSessionInfo> getSessionInfo(String sessionId) throws StorageException {
        return this.sessionIndex.get((Object)sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionInfo(String sessionId, ExternalAnalysisSessionInfo sessionInfo) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            this.sessionIndex.put((Object)sessionId, (Object)sessionInfo);
            this.unscheduledSessionIndex.storeKey(sessionId);
            this.commitIndex.put((Object)sessionInfo.getCommit(), (Object)this.commitIndex.get((Object)sessionInfo.getCommit()).map(existingId -> ExternalAnalysisImportSessionIndex.addSessionId(existingId, sessionId)).orElse(sessionId));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static String addSessionId(String existingId, String sessionId) {
        if (existingId.contains(sessionId)) {
            return existingId;
        }
        return existingId + SESSION_ID_DELIMITER + sessionId;
    }

    public void deleteSession(String sessionId) throws StorageException {
        this.deleteSessions(List.of(sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public void deleteSessions(Collection<@Nullable String> sessionIds) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            @Nullable List sessions = this.sessionIndex.get((SequencedCollection)CollectionUtils.filterNullEntries(sessionIds));
            for (ExternalAnalysisSessionInfo session : sessions) {
                if (session == null) continue;
                String sessionId = session.getSessionId();
                this.valueIndexProvider.apply(sessionId).clear();
                this.unscheduledSessionIndex.removeKey(sessionId);
                this.sessionIndex.remove((Object)sessionId);
                this.removeCommitToSessionMapping(session.getCommit(), sessionId);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnscheduledSessionIds(Collection<String> sessionIds) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            this.unscheduledSessionIndex.clear();
            this.unscheduledSessionIndex.storeKeys(new ArrayList<String>(sessionIds));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void insertAndMergeImportInfos(ExternalAnalysisSessionInfo session, List<ExternalAnalysisImportInfos> newInfos) throws StorageException {
        this.mergeImportInfos(session, newInfos, ScatteredCollectionIndex::addElements);
    }

    void insertImportInfos(ExternalAnalysisSessionInfo session, Collection<ExternalAnalysisImportInfos> infos) throws StorageException {
        this.mergeImportInfos(session, infos, ScatteredCollectionIndex::put);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeImportInfos(ExternalAnalysisSessionInfo session, Collection<ExternalAnalysisImportInfos> infos, ValueIndexMerger<ExternalAnalysisImportInfo<?>> mergeFunction) throws StorageException {
        Map<String, List<ExternalAnalysisImportInfo>> infosByPath = infos.stream().flatMap(infosObject -> infosObject.getInfos().stream()).collect(Collectors.groupingBy(ExternalAnalysisImportInfo::getUniformPath));
        ScatteredCollectionIndex<ExternalAnalysisImportInfo<?>> sessionValueIndex = this.valueIndexProvider.apply(session.getSessionId());
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            for (Map.Entry<String, List<ExternalAnalysisImportInfo>> entry : infosByPath.entrySet()) {
                ExternalAnalysisImportInfos analysisImportInfos = new ExternalAnalysisImportInfos(entry.getValue());
                session.updateMaxReportSize(analysisImportInfos);
                mergeFunction.merge(sessionValueIndex, StringUtils.stringToBytes((String)entry.getKey()), (Collection)entry.getValue());
            }
            this.setSessionInfo(session.getSessionId(), session);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUniformPathsInSession(ExternalAnalysisSessionInfo session) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.valueIndexProvider.apply(session.getSessionId()).listKeys().stream().map(StringUtils::bytesToString).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, @Nullable ExternalAnalysisImportInfos> getImportInfos(ExternalAnalysisSessionInfo session, Collection<String> uniformPaths) throws StorageException {
        ScatteredCollectionIndex<ExternalAnalysisImportInfo<?>> sessionSpecificValueIndex = this.valueIndexProvider.apply(session.getSessionId());
        HashMap<String, ExternalAnalysisImportInfos> infosByPath = new HashMap<String, ExternalAnalysisImportInfos>();
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            for (String uniformPath : uniformPaths) {
                sessionSpecificValueIndex.get(StringUtils.stringToBytes((String)uniformPath)).map(ExternalAnalysisImportInfos::new).ifPresent(infos -> infosByPath.put(uniformPath, (ExternalAnalysisImportInfos)infos));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return infosByPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, @Nullable ExternalAnalysisImportInfos> getImportInfos(ExternalAnalysisSessionInfo session) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.getImportInfos(session, this.getUniformPathsInSession(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markSessionAsScheduled(String sessionId) throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            boolean result = this.unscheduledSessionIndex.hasKey(sessionId);
            this.unscheduledSessionIndex.removeKey(sessionId);
            if (!result) {
                LOGGER.warn("Tried to mark session {} as scheduled, but it was no longer in the list of unscheduled sessions. This indicates that it was already previously scheduled.", (Object)sessionId);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllUnscheduledSessionIds() throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.unscheduledSessionIndex.listKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllSessionIds() throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sessionIndex.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PairList<String, ExternalAnalysisSessionInfo> getAllSessionInfos() throws StorageException {
        Class<ExternalAnalysisImportSessionIndex> clazz = ExternalAnalysisImportSessionIndex.class;
        synchronized (ExternalAnalysisImportSessionIndex.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sessionIndex.getEntries();
        }
    }

    @FunctionalInterface
    private static interface ValueIndexMerger<T> {
        public void merge(ScatteredCollectionIndex<T> var1, byte[] var2, Collection<T> var3) throws StorageException;
    }
}

