/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

@Index(name="external-properties", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.BACKUP})
public class ExternalPropertiesIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "external-properties";
    private static final String DUE_DATE_PARTITION = "d";
    private static final String GENERIC_PARTITION = "p";
    private final ValueIndex<Long> dueDateDelegate;
    private final ValueIndex<PairList<String, String>> genericPropertiesDelegate;

    public ExternalPropertiesIndex(IStore store) {
        this.dueDateDelegate = ValueIndex.forLong((IStore)new DelegatingPartitionStore(store, DUE_DATE_PARTITION));
        this.genericPropertiesDelegate = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, GENERIC_PARTITION));
    }

    public @Nullable Long getDueDate(String findingId) throws StorageException {
        return (Long)this.dueDateDelegate.getValue(findingId);
    }

    public void setDueDate(String findingId, long dueDate) throws StorageException {
        this.dueDateDelegate.setValue(findingId, (Object)dueDate);
    }

    public void setDueDates(Map<String, Long> dueDates) throws StorageException {
        this.dueDateDelegate.setValues(PairList.fromMap(dueDates));
    }

    public void deleteDueDate(String findingId) throws StorageException {
        this.dueDateDelegate.removeValue(findingId);
    }

    public PairList<String, String> getGenericProperties(String findingId) throws StorageException {
        return Objects.requireNonNullElseGet((PairList)this.genericPropertiesDelegate.getValue(findingId), PairList::new);
    }

    public void setGenericProperties(String findingId, PairList<String, String> properties) throws StorageException {
        this.genericPropertiesDelegate.setValue(findingId, properties);
    }

    public void setGenericPropertiesMultiple(Map<String, Map<String, String>> properties) throws StorageException {
        PairList values = new PairList();
        for (Map.Entry<String, Map<String, String>> entry : properties.entrySet()) {
            values.add((Object)entry.getKey(), (Object)new PairList(entry.getValue()));
        }
        this.genericPropertiesDelegate.setValues(values);
    }

    public void deleteGenericProperties(String findingId) throws StorageException {
        this.genericPropertiesDelegate.removeValue(findingId);
    }

    public Map<String, Long> getDueDates(Collection<String> ids) throws StorageException {
        List<String> idList = List.copyOf(ids);
        List dueDates = this.dueDateDelegate.getValues(idList);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (int i = 0; i < idList.size(); ++i) {
            Long dueDate = (Long)dueDates.get(i);
            if (dueDate == null) continue;
            result.put(idList.get(i), dueDate);
        }
        return result;
    }

    public Map<String, Map<String, String>> getGenericProperties(Collection<String> ids) throws StorageException {
        List<String> idList = List.copyOf(ids);
        List propertiesList = this.genericPropertiesDelegate.getValues(idList);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < idList.size(); ++i) {
            PairList properties = (PairList)propertiesList.get(i);
            if (properties != null) {
                result.put(idList.get(i), properties.toMap());
                continue;
            }
            result.put(idList.get(i), Map.of());
        }
        return result;
    }
}

