/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.result;

import com.teamscale.index.external.result.ExternalAnalysisResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<ExternalAnalysisResult<?>>> results = new HashMap();

    public ExternalAnalysisResults() {
    }

    public ExternalAnalysisResults(List<ExternalAnalysisResult<?>> results) {
        results.forEach(this::addResult);
    }

    public ExternalAnalysisResults(ExternalAnalysisResult<?> ... results) {
        this(Arrays.asList(results));
    }

    public ExternalAnalysisResults(ExternalAnalysisResults ... resultLists) {
        Arrays.stream(resultLists).forEach(this::addAll);
    }

    public void addResult(ExternalAnalysisResult<?> result) {
        String className = result.getClass().getCanonicalName();
        this.results.putIfAbsent(className, new ArrayList());
        this.results.get(className).add(result);
    }

    public void addAll(ExternalAnalysisResults resultsToAdd) {
        resultsToAdd.results.values().stream().flatMap(Collection::stream).forEach(this::addResult);
    }

    public <T extends ExternalAnalysisResult<?>> List<T> getByType(Class<T> clazz) {
        return this.getByType(clazz.getCanonicalName());
    }

    public <T extends ExternalAnalysisResult<?>> List<T> getByType(String canonicalClassName) {
        List<ExternalAnalysisResult<?>> result = this.results.get(canonicalClassName);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Set<String> getCanonicalTypeNames() {
        return Collections.unmodifiableSet(this.results.keySet());
    }

    public <T extends ExternalAnalysisResult<?>> void executeOnType(Class<T> clazz, Consumer<T> consumer) {
        this.getByType(clazz).forEach(consumer);
    }

    public <T extends ExternalAnalysisResult<?>> void mergeResultsOfType(Class<T> clazz, BinaryOperator<T> mergeFunction) {
        Optional mergedResult = this.getByType(clazz).stream().reduce(mergeFunction);
        if (mergedResult.isPresent()) {
            this.results.remove(clazz.getCanonicalName());
            this.addResult((ExternalAnalysisResult)mergedResult.get());
        }
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public <T extends ExternalAnalysisResult<?>> void removeIfType(Class<T> clazz, Predicate<T> filter) {
        List<T> resultsByType = this.getByType(clazz);
        resultsByType.removeIf(filter);
        if (resultsByType.isEmpty()) {
            this.results.remove(clazz.getCanonicalName());
        }
    }
}

