/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.index.backup.read.BackupReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.core.configuration.ConfigurationException;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemProviderBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.string.StringUtils;

public abstract class BackupModifierToolBase
extends CommandLineBase<NeverThrownRuntimeException> {
    private static final Pattern ZIP_FILE_ENDING = Pattern.compile("\\.zip$");
    protected String backupFilename;
    protected long endTimestamp = Long.MAX_VALUE;
    protected String databaseConfigurationFile;

    protected void run() {
        File inputFile = this.checkPreconditions();
        File newBackup = new File(StringUtils.replaceFirst((String)this.backupFilename, (Pattern)ZIP_FILE_ENDING, (String)"-new.zip"));
        try {
            IStorageSystemProvider storageSystemProvider = this.createStorageSystemProvider();
            IStorageSystem storageSystem = storageSystemProvider.openStorageSystem(UUID.randomUUID().toString());
            this.openAndProcessZip(inputFile, newBackup, storageSystem);
        }
        catch (StorageException e) {
            BackupModifierToolBase.exitWithMessage((String)("Failed to open/close storage system: " + e.getMessage()), (Exception)((Object)e));
        }
    }

    private void openAndProcessZip(File inputFile, File newBackup, IStorageSystem storageSystem) {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(newBackup));){
            zos.setUseZip64(Zip64Mode.Always);
            try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new FileInputStream(inputFile));){
                this.processZip(zis, zos, storageSystem);
            }
            BackupModifierToolBase.printInfo((String)"\nDone, new backup written to:");
            BackupModifierToolBase.printInfo((String)newBackup.getAbsolutePath());
        }
        catch (IOException e) {
            BackupModifierToolBase.exitWithMessage((String)("Failed to read or write ZIP file: " + e.getMessage()), (Exception)e);
        }
    }

    protected File checkPreconditions() {
        BackupModifierToolBase.exitIfTrue((this.backupFilename == null ? 1 : 0) != 0, (String)"Must provide name of backup file!");
        File inputFile = new File(this.backupFilename);
        BackupModifierToolBase.exitIfFalse((inputFile.canRead() && inputFile.isFile() ? 1 : 0) != 0, (String)"Input file does not exist or is not a readable file!");
        this.exitIfUnexpectedVersion(inputFile);
        return inputFile;
    }

    private IStorageSystemProvider createStorageSystemProvider() throws StorageException {
        DatabaseConfiguration databaseConfiguration = this.loadDatabaseConfiguration();
        IStorageSystemProvider storageSystemProvider = databaseConfiguration.createStorageSystemProvider(1);
        return new DeleteOnCloseStorageSystemProvider(storageSystemProvider, databaseConfiguration);
    }

    private DatabaseConfiguration loadDatabaseConfiguration() {
        try {
            Properties databaseProperties = new Properties();
            if (this.databaseConfigurationFile != null) {
                try (FileInputStream s = new FileInputStream(this.databaseConfigurationFile);){
                    databaseProperties.load(s);
                }
            }
            return DatabaseConfiguration.readFromProperties((Properties)databaseProperties);
        }
        catch (IOException | ConfigurationException e) {
            BackupModifierToolBase.exitWithMessage((String)"Failed to read provided database configuration file '%s': %s".formatted(this.databaseConfigurationFile, e.getMessage()), (Exception)e);
            throw new AssertionError("Unreachable code", e);
        }
    }

    private void exitIfUnexpectedVersion(File inputFile) {
        try (ZipFile backupFile = new ZipFile(inputFile);){
            EStorageSystemVersion version = BackupReader.extractVersionEntry(backupFile);
            BackupModifierToolBase.exitIfFalse((version == this.getExpectedStorageSystemVersion() ? 1 : 0) != 0, (String)("The version of the backup file does not match the version of this Teamscale instance. Please use Teamscale import to convert the backup first! Got " + String.valueOf(version) + ", expected " + String.valueOf(this.getExpectedStorageSystemVersion())));
        }
        catch (IOException e) {
            BackupModifierToolBase.exitWithMessage((String)("Failed to read ZIP file: " + e.getMessage()), (Exception)e);
        }
    }

    protected EStorageSystemVersion getExpectedStorageSystemVersion() {
        return EStorageSystemVersion.CURRENT_VERSION;
    }

    private void processZip(ZipArchiveInputStream zis, ZipArchiveOutputStream zos, IStorageSystem storageSystem) throws IOException {
        ZipArchiveEntry entry;
        while ((entry = zis.getNextZipEntry()) != null) {
            ZipArchiveEntry newEntry = new ZipArchiveEntry(entry);
            newEntry.setCompressedSize(-1L);
            zos.putArchiveEntry(newEntry);
            String fullStoreName = entry.getName();
            Optional<String> matchedStore = this.getChangedStoreNames().stream().filter(store -> fullStoreName.endsWith("/" + store)).findFirst();
            if (matchedStore.isPresent()) {
                this.handleChangedStore(zis, zos, storageSystem, fullStoreName, matchedStore.get());
            } else {
                FileSystemUtils.copy((InputStream)zis, (OutputStream)zos);
            }
            zos.closeArchiveEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangedStore(ZipArchiveInputStream zis, ZipArchiveOutputStream zos, IStorageSystem storageSystem, String fullStoreName, String storeName) throws IOException {
        IStore store = BackupModifierToolBase.createStoreForEntry(fullStoreName, storageSystem);
        StoreFactory storeFactory = new StoreFactory(fullStoreName, storageSystem);
        try {
            BackupModifierToolBase.printInfo((String)("Reading " + fullStoreName));
            StorageUtils.importStore((IStore)store, (DataInputStream)new DataInputStream((InputStream)zis));
            this.processStore(storeName, store, zos, storeFactory);
        }
        catch (StorageException e) {
            BackupModifierToolBase.exitWithMessage((String)("Failed to read store " + fullStoreName + ": " + e.getMessage()), (Exception)((Object)e));
        }
        finally {
            storeFactory.removeAllStores();
            BackupModifierToolBase.removeStore(storageSystem, fullStoreName);
        }
    }

    private static void removeStore(IStorageSystem storageSystem, String storeName) {
        try {
            BackupModifierToolBase.printInfo((String)("Removing temporary store " + storeName));
            storageSystem.removeStore(storeName);
        }
        catch (StorageException e) {
            BackupModifierToolBase.printError((String)("Failed to remove store " + storeName), (Exception)((Object)e));
        }
    }

    private static IStore createStoreForEntry(String name, IStorageSystem storageSystem) {
        try {
            return storageSystem.openStore(name);
        }
        catch (StorageException e) {
            BackupModifierToolBase.exitWithMessage((String)("Unable to create store: " + name), (Exception)((Object)e));
            throw new AssertionError("Unreachable code", e);
        }
    }

    protected abstract Set<String> getChangedStoreNames();

    protected abstract void processStore(String var1, IStore var2, ZipArchiveOutputStream var3, StoreFactory var4) throws StorageException, IOException;

    protected static void writeOutputStore(ZipArchiveOutputStream zos, IStore outputStore) throws StorageException, IOException {
        DataOutputStream dos = new DataOutputStream((OutputStream)zos);
        StorageUtils.exportStore((IStore)outputStore, (DataOutputStream)dos);
        dos.flush();
    }

    @Option(shortName=101, longName="end", description="The timestamp to end with.")
    public void setEndTimestamp(long timestamp) {
        BackupModifierToolBase.exitIfFalse((this.endTimestamp == Long.MAX_VALUE ? 1 : 0) != 0, (String)"May only set end timestamp once!");
        this.endTimestamp = timestamp;
    }

    @Option(shortName=102, longName="file", description="Set the name of the file to work with.")
    public void setBackupFilename(String filename) {
        BackupModifierToolBase.exitIfFalse((this.backupFilename == null ? 1 : 0) != 0, (String)"May only set filename once!");
        this.backupFilename = filename;
    }

    @Option(longName="databaseConfiguration", description="The file containing configuration for the database. If nothing is configured, the default database to be used is an in-memory database, which may not be suitable for large backups. The expected format is the same as for the 'teamscale.properties' file.")
    public void setDatabaseConfigurationFile(String databaseConfigurationFile) {
        BackupModifierToolBase.exitIfFalse((this.databaseConfigurationFile == null ? 1 : 0) != 0, (String)"May only set databaseConfigurationFile once!");
        this.databaseConfigurationFile = databaseConfigurationFile;
    }

    private static class DeleteOnCloseStorageSystemProvider
    extends DelegatingStorageSystemProviderBase {
        private final DatabaseConfiguration databaseConfiguration;

        private DeleteOnCloseStorageSystemProvider(IStorageSystemProvider storageSystemProvider, DatabaseConfiguration databaseConfiguration) {
            super(storageSystemProvider);
            this.databaseConfiguration = databaseConfiguration;
        }

        protected IStore wrapStore(IStore store, String storeName, String storageSystemName) {
            return store;
        }

        public void close() throws StorageException {
            super.close();
            if (this.databaseConfiguration.getDatabaseType().isLocalDiskBased()) {
                try {
                    FileSystemUtils.deleteRecursively((File)this.databaseConfiguration.getStorageDirectory());
                }
                catch (IOException e) {
                    throw new StorageException((Throwable)e);
                }
            }
        }
    }

    protected static class StoreFactory {
        private final String prefix;
        private final IStorageSystem storageSystem;
        private final Map<IStore, String> openStores = new IdentityHashMap<IStore, String>();
        private int nextStoreIndex;

        private StoreFactory(String prefix, IStorageSystem storageSystem) {
            this.prefix = prefix;
            this.storageSystem = storageSystem;
        }

        public IStore createNewStore() throws StorageException {
            String storeName = this.prefix + "_" + this.nextStoreIndex++;
            IStore store = this.storageSystem.openStore(storeName);
            this.openStores.put(store, storeName);
            return store;
        }

        public void removeStore(IStore store) {
            String storeName = this.openStores.remove(store);
            CCSMAssert.isNotNull((Object)storeName, () -> "Store \"%s\" is no known store that can be closed.".formatted(store));
            BackupModifierToolBase.removeStore(this.storageSystem, storeName);
        }

        private void removeAllStores() {
            for (String storeName : this.openStores.values()) {
                BackupModifierToolBase.removeStore(this.storageSystem, storeName);
            }
            this.openStores.clear();
        }
    }
}

