/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.index.findings.CppFileUtils;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.clangtidy.ShallowCodeFileRepresentation;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.Nullable;

public abstract class ClangTidyAndCppcheckRunnerBase {
    protected static final Logger LOGGER = LogManager.getLogger();

    public static List<String> concatenateCompilerArguments(List<String> localCompilerArguments, List<String> globalCompilerArguments) {
        ArrayList<String> result = new ArrayList<String>(localCompilerArguments);
        result.addAll(globalCompilerArguments);
        return result;
    }

    protected static Map<String, ShallowCodeFileRepresentation> loadFileContents(List<BasicTokenElementInfo> filesToAnalyze, Map<String, Set<CppIncludeHandler.IncludeFile>> relevantIncludeFilesMap, CppIncludeHandler includeHandler) throws StorageException {
        HashSet<String> writtenUniformPaths = new HashSet<String>();
        HashMap<String, ShallowCodeFileRepresentation> fileContents = new HashMap<String, ShallowCodeFileRepresentation>();
        for (BasicTokenElementInfo element : filesToAnalyze) {
            if (writtenUniformPaths.contains(element.getUniformPath())) continue;
            fileContents.put(element.getUniformPath(), ShallowCodeFileRepresentation.fromBasicTokenElementInfo(element));
            writtenUniformPaths.add(element.getUniformPath());
            Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles = relevantIncludeFilesMap.get(element.getUniformPath());
            for (CppIncludeHandler.IncludeFile includedFile : relevantIncludeFiles) {
                ShallowCodeFileRepresentation includeElement = includeHandler.loadIncludeElement(includedFile.uniformPath());
                writtenUniformPaths.add(includeElement.uniformPath());
                fileContents.put(includeElement.uniformPath(), includeElement);
            }
        }
        return fileContents;
    }

    public static void writeFiles(Collection<ShallowCodeFileRepresentation> fileContents, File codeDirectory) throws IOException {
        for (ShallowCodeFileRepresentation file : fileContents) {
            String uniformPath = file.uniformPath();
            String content = file.textContent();
            CppFileUtils.saveFile(uniformPath, content, codeDirectory);
        }
    }

    public static Map<String, Set<CppIncludeHandler.IncludeFile>> computeRelevantIncludeFilesMap(Collection<BasicTokenElementInfo> filesToAnalyze, CppIncludeHandler includeHandler, Map<String, IncludePathDetail> includePathDetails) throws StorageException {
        HashMap<String, Set<CppIncludeHandler.IncludeFile>> relevantIncludeFilesMap = new HashMap<String, Set<CppIncludeHandler.IncludeFile>>();
        for (BasicTokenElementInfo element : filesToAnalyze) {
            @Nullable IncludePathDetail includePathDetail = includePathDetails.get(element.getUniformPath());
            List<String> resolvedIncludeSearchPaths = List.of();
            if (includePathDetail != null) {
                resolvedIncludeSearchPaths = includePathDetail.getResolvedIncludeSearchPaths().stream().filter(path -> !FileSystemUtils.isAbsolutePath((String)path)).toList();
            }
            Set<CppIncludeHandler.IncludeFile> relevantIncludeFiles = includeHandler.determineRelevantIncludeFiles(element, new HashSet<String>(), resolvedIncludeSearchPaths);
            relevantIncludeFilesMap.put(element.getUniformPath(), relevantIncludeFiles);
        }
        return relevantIncludeFilesMap;
    }

    public static void executeJobsInParallel(List<Callable<Void>> jobs, ExecutorService jobExecutor, String runnerName) {
        LOGGER.debug("Executing {} jobs for runner {}", (Object)jobs.size(), (Object)runnerName);
        try {
            List<Future<Void>> futures = jobExecutor.invokeAll(jobs);
            if (futures.stream().anyMatch(future -> !future.isDone())) {
                LOGGER.error("Some " + runnerName + " job was not completed (future was not done). ExecutorService.invokeAll violated it's contract.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while running " + runnerName + ". Results might be incomplete.", (Throwable)e);
        }
        LOGGER.debug("Execution of the {} jobs for runner {} is finished", (Object)jobs.size(), (Object)runnerName);
    }
}

