/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cppcheck;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppIntegratedToolUtils;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.cppcheck.CppcheckRunner;
import com.teamscale.index.findings.cross_file_analysis.CrossFileFindingsAnalysisBase;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CppcheckSynchronizer
extends CrossFileFindingsAnalysisBase {
    public static final String CHECKS_PARAMETER = "checks";
    public static final String ENABLED_CHECKS_FOR_C_REGEX_PARAMETER = "enabled-checks-for-c-regex";
    private static final String FINDING_PARTITION = "cppcheck";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Set<ELanguage> SUPPORTED_LANGUAGES = LanguageGroups.C_CPP_AND_MS_CLI;
    private static final Set<String> SUPPORTED_FILE_NAME_EXTENSIONS = Set.of("cpp", "cxx", "cc", "c++", "tpp", "txx", "ipp", "ixx", "c", "cl");
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="enabled-checks-for-c-regex")
    private CodeScopeAware<String> enabledChecksForCRegex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SystemIncludeFileCacheIndex systemIncludeFileCacheIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CompileCommandIndex compileCommandIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected PathLookupIndex pathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    protected TokenElementIndex contentIndex;
    @DeltaSource(value=BasicTokenElementIndex.class, indexName="basic-token-elements")
    protected KeyDelta basicContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    ReparseRequiredIndex reparseRequiredIndex;
    @DeltaSource(value=CompileCommandIndex.class, indexName="compile-commands")
    protected KeyDelta compileCommandIndexDelta;

    public void execute() throws StorageException {
        try (TemporaryDirectory tmpDir = CppcheckSynchronizer.getTempDirectory((String)"TeamscaleCppcheck");){
            List<BasicTokenElementInfo> elementsToAnalyze = this.determinePathsToAnalyze();
            if (elementsToAnalyze.isEmpty()) {
                this.storeFindings((Map<String, List<IndexFinding>>)CollectionUtils.emptyMap(), (CodeScopeAware<Set<String>>)CodeScopeAware.empty(), this.basicContentDelta.getDeletedKeysAsStrings(), FINDING_PARTITION);
                return;
            }
            Set<CodeScopeName> relevantCodeScopeNames = CodeScopeUtils.determineRelevantCodeScopeNames(elementsToAnalyze);
            CodeScopeAware<List<String>> globalCompilerArgumentsPerCodeScope = CppIncludeHandler.determineGlobalCompilerIncludeDirArguments(this.metaIndex, relevantCodeScopeNames);
            boolean cppcheckPremiumEnabled = this.isCppcheckPremiumEnabled(relevantCodeScopeNames);
            CppcheckSynchronizer.verifyCppcheckVersion(cppcheckPremiumEnabled);
            SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create(this.metaIndex, this.systemIncludeFileCacheIndex);
            FileIncludeLookup fileIncludeLookup = new FileIncludeLookup(this.pathLookupIndex.createPreloadedLookup(), systemIncludeFileLookup);
            CppIncludeHandler includeHandler = new CppIncludeHandler(this.basicTokenElementIndex, this.compileCommandIndex, fileIncludeLookup, this.getLockProvider());
            CodeScopeAware<Map<String, CheckMapping>> enabledCheckMappings = CppcheckSynchronizer.loadCheckMappingsForEnabledChecks(this.selectedChecks, relevantCodeScopeNames, cppcheckPremiumEnabled);
            CppToolAnalysisTokenElementDetails tokenElementDetails = CppToolAnalysisTokenElementDetails.loadDetailsForBasicTokenElements(elementsToAnalyze, this.contentIndex);
            ListMap<String, IndexFinding> findingsByAnalysisPath = CppcheckRunner.prepareAndRunCppcheck(elementsToAnalyze, tmpDir.getPath().toFile(), enabledCheckMappings, this.enabledChecksForCRegex, globalCompilerArgumentsPerCodeScope, false, includeHandler, cppcheckPremiumEnabled, tokenElementDetails);
            CodeScopeAware analyzedPathsByCodeScope = CodeScopeUtils.groupElementsByCodeScope(elementsToAnalyze).map(elements -> CollectionUtils.mapToSet((Collection)elements, BasicTokenElementInfo::getUniformPath));
            this.storeFindings(findingsByAnalysisPath.toMapOfLists(), (CodeScopeAware<Set<String>>)analyzedPathsByCodeScope, this.basicContentDelta.getDeletedKeysAsStrings(), FINDING_PARTITION);
        }
        catch (IOException | ConQATException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    public static CodeScopeAware<Map<String, CheckMapping>> loadCheckMappingsForEnabledChecks(CodeScopeAware<List<String>> selectedCheckIds, Set<CodeScopeName> relevantCodeScopeNames, boolean cppcheckPremiumEnabled) throws StorageException {
        CodeScopeAware enabledCheckMappingsForCodeScopes = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : selectedCheckIds.getCodeScopeNames()) {
            if (!relevantCodeScopeNames.contains(codeScopeName)) continue;
            Resource mappingsFile = cppcheckPremiumEnabled ? Resource.of(CppcheckSynchronizer.class, (String)"premium/check-mappings.tsv") : Resource.of(CppcheckSynchronizer.class, (String)"opensource/check-mappings.tsv");
            Map allMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile);
            HashMap<String, CheckMapping> enabledCheckMappings = new HashMap<String, CheckMapping>();
            for (String selectedCheckId : (List)selectedCheckIds.getValue(codeScopeName)) {
                CheckMapping checkMapping = (CheckMapping)allMappings.get(selectedCheckId);
                if (checkMapping == null) continue;
                enabledCheckMappings.put(selectedCheckId, checkMapping);
            }
            enabledCheckMappingsForCodeScopes.setValue(codeScopeName, enabledCheckMappings);
        }
        return enabledCheckMappingsForCodeScopes;
    }

    private List<BasicTokenElementInfo> determinePathsToAnalyze() throws StorageException {
        HashSet<String> changedKeys = new HashSet<String>(this.basicContentDelta.getAddedOrChangedKeysAsStrings());
        changedKeys.addAll(this.compileCommandIndexDelta.getAddedOrChangedKeysAsStrings());
        if (!CppIntegratedToolUtils.isReanalyzeOnHeaderChangeAnalysisDisabled() && EFeatureToggle.ENABLE_CLANG_TIDY_CPPCHECK_CROSS_FILE_ANALYSIS.isEnabled()) {
            changedKeys.addAll(CppIntegratedToolUtils.determineReanalysisRequiredPaths(this.reparseRequiredIndex, this.getSchedulingCommit()));
        }
        changedKeys.removeIf(uniformPath -> {
            String extension = FileSystemUtils.getFileExtension((String)uniformPath);
            return extension == null || !SUPPORTED_FILE_NAME_EXTENSIONS.contains(extension);
        });
        ArrayList<BasicTokenElementInfo> elementsToAnalyze = new ArrayList<BasicTokenElementInfo>();
        for (BasicTokenElementInfo element : this.basicTokenElementIndex.getTokenElements(new ArrayList<String>(changedKeys))) {
            if (element == null || !SUPPORTED_LANGUAGES.contains(element.getLanguage())) continue;
            elementsToAnalyze.add(element);
        }
        return elementsToAnalyze;
    }

    public static void verifyCppcheckVersion(boolean isCppcheckPremium) throws ConQATException {
        String expectedVersion = CppcheckSynchronizer.loadExpectedCppcheckVersion(isCppcheckPremium);
        Pair<Integer, String> actualVersion = CppcheckRunner.determineCppcheckVersion();
        if (actualVersion.getSecond() == null || !((String)actualVersion.getSecond()).contains(expectedVersion)) {
            throw new ConQATException("No cppcheck or wrong version. Return Code: " + String.valueOf(actualVersion.getFirst()) + " Output: " + (String)actualVersion.getSecond() + " Expected: " + expectedVersion);
        }
    }

    public static String loadExpectedCppcheckVersion(boolean isCppcheckPremium) {
        String content = Resource.of(CppcheckSynchronizer.class, (String)(isCppcheckPremium ? "premium/version.txt" : "opensource/version.txt")).getContent();
        StringBuilder expectedVersion = new StringBuilder();
        for (String line : StringUtils.splitLines((String)content)) {
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (!expectedVersion.isEmpty()) {
                expectedVersion.append("\n");
            }
            expectedVersion.append(line.trim());
        }
        return expectedVersion.toString();
    }

    private boolean isCppcheckPremiumEnabled(Set<CodeScopeName> relevantCodeScopeNames) throws StorageException {
        for (CodeScopeName codeScopeName : relevantCodeScopeNames) {
            ProjectConfiguration config = (ProjectConfiguration)this.metaIndex.getValue(ProjectConfiguration.class);
            AnalysisProfile analysisProfile = config.getEmbeddedProfile(codeScopeName);
            if (analysisProfile == null || !analysisProfile.getTools().contains((Object)EAnalysisTool.CPPCHECK_PREMIUM)) continue;
            return true;
        }
        return false;
    }
}

