/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.index.issue_reference.SpecItemReferenceBase;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class SpecItemCodeReference
extends SpecItemReferenceBase
implements Comparable<SpecItemCodeReference> {
    private static final long serialVersionUID = 1L;
    private static final String REFERENCED_ENTITY_PROPERTY = "referencedShallowEntity";
    private static final String REFERENCED_NON_PREPROCESSED_ENTITY_PROPERTY = "referencedNonPreprocessedShallowEntity";
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String COMMENT_OFFSET_WITH_REGION_PROPERTY = "commentOffsetWithRegion";
    private static final String COMMENT_LINE_NUMBER_PROPERTY = "commentLineNumber";
    private static final String TEST_IMPLEMENTATION_UNIFORM_PATH_PROPERTY = "testImplementationUniformPath";
    @JsonProperty(value="referencedShallowEntity")
    private final ReferencedShallowEntity referencedShallowEntity;
    @JsonProperty(value="referencedNonPreprocessedShallowEntity")
    private final @Nullable ReferencedShallowEntity referencedNonPreprocessedShallowEntity;
    @JsonProperty(value="commentOffsetWithRegion")
    private final @Nullable Pair<Integer, OffsetBasedRegion> commentOffsetWithRegion;
    @JsonProperty(value="commentLineNumber")
    private final int commentLineNumber;
    @JsonProperty(value="testImplementationUniformPath")
    private final @Nullable String testImplementationUniformPath;

    @JsonCreator
    public SpecItemCodeReference(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="referencedShallowEntity") ReferencedShallowEntity referencedShallowEntity, @JsonProperty(value="referencedNonPreprocessedShallowEntity") @Nullable ReferencedShallowEntity referencedNonPreprocessedShallowEntity, @JsonProperty(value="commentOffsetWithRegion") @Nullable Pair<Integer, OffsetBasedRegion> commentOffsetWithRegion, @JsonProperty(value="commentLineNumber") int commentLineNumber, @JsonProperty(value="testImplementationUniformPath") @Nullable String testImplementationUniformPath) {
        super(uniformPath);
        this.referencedShallowEntity = referencedShallowEntity;
        this.referencedNonPreprocessedShallowEntity = referencedNonPreprocessedShallowEntity;
        this.commentOffsetWithRegion = commentOffsetWithRegion;
        this.commentLineNumber = commentLineNumber;
        this.testImplementationUniformPath = testImplementationUniformPath;
    }

    @VisibleForTesting
    public SpecItemCodeReference(String uniformPath, ReferencedShallowEntity shallowEntity, String testImplementationUniformPath) {
        this(uniformPath, shallowEntity, shallowEntity, (Pair<Integer, OffsetBasedRegion>)new Pair((Object)0, (Object)new OffsetBasedRegion(0, 0)), 0, testImplementationUniformPath);
    }

    public ReferencedShallowEntity getReferencedShallowEntity() {
        return this.referencedShallowEntity;
    }

    public @Nullable ReferencedShallowEntity getReferencedNonPreprocessedShallowEntity() {
        return this.referencedNonPreprocessedShallowEntity;
    }

    public @Nullable Pair<Integer, OffsetBasedRegion> getCommentOffsetWithRegion() {
        return this.commentOffsetWithRegion;
    }

    public int getCommentLineNumber() {
        return this.commentLineNumber;
    }

    @Override
    public boolean isTestReference() {
        return !StringUtils.isEmpty((String)this.testImplementationUniformPath);
    }

    public @Nullable String getTestImplementationUniformPath() {
        return this.testImplementationUniformPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecItemCodeReference that = (SpecItemCodeReference)o;
        return this.commentLineNumber == that.commentLineNumber && Objects.equals(this.uniformPath, that.uniformPath) && Objects.equals(this.referencedShallowEntity, that.referencedShallowEntity) && Objects.equals(this.commentOffsetWithRegion, that.commentOffsetWithRegion);
    }

    public int hashCode() {
        return Objects.hash(this.uniformPath, this.referencedShallowEntity, this.commentOffsetWithRegion, this.commentLineNumber);
    }

    @Override
    public int compareTo(SpecItemCodeReference other) {
        return Comparator.comparing(SpecItemReferenceBase::getUniformPath).thenComparing(SpecItemCodeReference::getReferencedShallowEntity).thenComparing(SpecItemCodeReference::getReferencedNonPreprocessedShallowEntity, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(SpecItemCodeReference::getCommentOffsetWithRegion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(SpecItemCodeReference::getCommentLineNumber).thenComparing(SpecItemCodeReference::getTestImplementationUniformPath, Comparator.nullsFirst(Comparator.naturalOrder())).compare(this, other);
    }

    @IndexValueClass
    public static class ReferencedShallowEntity
    implements Serializable,
    Comparable<ReferencedShallowEntity> {
        private static final long serialVersionUID = 1L;
        private static final String ENTITY_NAME_PROPERTY = "name";
        private static final String ENTITY_SUBTYPE_PROPERTY = "subtype";
        private static final String ENTITY_START_OFFSET_PROPERTY = "startOffset";
        private static final String ENTITY_END_OFFSET_PROPERTY = "endOffset";
        private static final String ENTITY_START_LINE_PROPERTY = "startLine";
        private static final String ENTITY_END_LINE_PROPERTY = "endLine";
        private static final String ENTITY_START_TOKENS_PROPERTY = "startTokenTexts";
        @JsonProperty(value="name")
        private final @Nullable String name;
        @JsonProperty(value="subtype")
        private final String subtype;
        @JsonProperty(value="startTokenTexts")
        private final List<String> startTokenTexts;
        @JsonProperty(value="startOffset")
        private final int startOffset;
        @JsonProperty(value="endOffset")
        private final int endOffset;
        @JsonProperty(value="startLine")
        private final int startLine;
        @JsonProperty(value="endLine")
        private final int endLine;

        @JsonCreator
        public ReferencedShallowEntity(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="subtype") String subtype, @JsonProperty(value="startTokenTexts") List<String> startTokenTexts, @JsonProperty(value="startOffset") int startOffset, @JsonProperty(value="endOffset") int endOffset, @JsonProperty(value="startLine") int startLine, @JsonProperty(value="endLine") int endLine) {
            Preconditions.checkNotNull((Object)subtype);
            Preconditions.checkNotNull(startTokenTexts);
            this.name = name;
            this.subtype = subtype;
            this.startTokenTexts = startTokenTexts;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @VisibleForTesting
        public ReferencedShallowEntity(String name) {
            this(name, "", Collections.emptyList(), 0, 0, 0, 0);
        }

        public static ReferencedShallowEntity fromShallowEntity(ShallowEntity entity) {
            return new ReferencedShallowEntity(entity.getName(), StringUtils.capitalize((String)entity.getSubtype()), entity.ownStartTokens().stream().map(IToken::getText).collect(Collectors.toList()), entity.getStartOffset(), entity.getEndOffset(), entity.getStartLine(), entity.getEndLine());
        }

        public @Nullable String getName() {
            return this.name;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public List<String> getStartTokenTexts() {
            return this.startTokenTexts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReferencedShallowEntity that = (ReferencedShallowEntity)o;
            return this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.startLine == that.startLine && this.endLine == that.endLine && Objects.equals(this.name, that.name) && Objects.equals(this.subtype, that.subtype) && Objects.equals(this.startTokenTexts, that.startTokenTexts);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.subtype, this.startTokenTexts, this.startOffset, this.endOffset, this.startLine, this.endLine);
        }

        @Override
        public int compareTo(ReferencedShallowEntity other) {
            return Comparator.comparing(ReferencedShallowEntity::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(ReferencedShallowEntity::getSubtype).thenComparing(ReferencedShallowEntity::getStartOffset).thenComparing(ReferencedShallowEntity::getEndOffset).compare(this, other);
        }
    }
}

