/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.client.GitHubClientBase;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.index.issues.github.client.IGitHubIssueApi;
import com.teamscale.index.issues.github.client.model.GitHubIssue;
import com.teamscale.index.issues.gitlab.client.PaginatedServiceCallStreamSource;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.stream.IStreamWithException;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;

public class GitHubIssueClient
extends GitHubClientBase<IGitHubIssueApi> {
    public GitHubIssueClient(String apiBaseUrl, @Nullable String username, String password, @Nullable Logger interactionLogger) {
        super(apiBaseUrl, username, password, interactionLogger, IGitHubIssueApi.class);
    }

    public void testGetIssues(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        ((IGitHubIssueApi)this.gitHubApi).getIssues(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), "", 5);
    }

    public IStreamWithException<GitHubIssue, ServiceCallException> getIssues(PlatformRepositoryIdentifier repositoryIdentifier, String updatedAfter) throws ServiceCallException {
        return GitHubIssueClient.getPaginatedResults(((IGitHubIssueApi)this.gitHubApi).getIssues(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), updatedAfter, 100), ((IGitHubIssueApi)this.gitHubApi)::getIssuesFromNextPage).filter(issue -> issue.pullRequest() == null);
    }

    private static <T> IStreamWithException<T, ServiceCallException> getPaginatedResults(Call<? extends Iterable<T>> initialRequest, Function<String, Call<? extends Iterable<T>>> followupRequest) {
        return IStreamWithException.of(new PaginatedServiceCallStreamSource(initialRequest, followupRequest));
    }

    public GitHubUser getUser() throws ServiceCallException {
        return ((IGitHubIssueApi)this.gitHubApi).getUser();
    }
}

