/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.tfs;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.rest.HttpRequestRetryStepParameters;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.core.tfs.TfsWorkItem;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.OnceEveryNthPollCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleaner;
import com.teamscale.index.issues.tfs.TfsWiqlHelper;
import com.teamscale.index.issues.tfs.TfsWorkItemFilterParameters;
import com.teamscale.index.issues.tfs.TfsWorkItemRevisionFetcher;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.BidirectionalMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class TfsWorkItemSynchronizerBase<T extends TeamscaleIssue>
extends IssueTrackerSynchronizerBase<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String ITEM_TYPE_PARAMETER = "item-type";
    public static final String CLOSED_STATE_PARAMETER = "closed-state";
    public static final String INCLUDE_HISTORY_PARAMETER = "include-history";
    @StepParameter(value="include-history", optional=true)
    private boolean includeHistory = true;
    @StepParameterObject
    private final HttpRequestRetryStepParameters retryPolicy = new HttpRequestRetryStepParameters(HttpRequestRetryPolicy.AZURE_DEVOPS);
    @StepParameterObject
    private final OnceEveryNthPollCleanupStrategy cleanupStrategy = new OnceEveryNthPollCleanupStrategy();
    @StepParameterObject
    private final TfsWorkItemFilterParameters filterParameters = new TfsWorkItemFilterParameters();
    @StepParameter(value="closed-state", optional=true)
    protected final Set<String> closedStates = new HashSet<String>();
    protected IWorkItemRestClient workItemRestClient;
    private TfsWorkItemRevisionFetcher revisionFetcher;
    private static final String[] FIELDS_THAT_ARE_ALWAYS_QUERIED_FROM_TFS = new String[]{"System.Id", "System.Title", "System.AssignedTo", "System.CreatedBy", "System.Description", "Microsoft.VSTS.TCM.ReproSteps", "System.CreatedDate", "System.ChangedDate", "System.State", "System.AreaPath", "System.TeamProject", "System.WorkItemType"};
    public static final String WORK_ITEM_TYPE_FIELD_NAME = "Work Item Type";
    private BidirectionalMap<String, String> fieldNameToReferenceNameMapping;

    @Override
    protected void init() throws BugTrackerException {
        this.workItemRestClient = new TfsHttpConnection(this.getUrl(), this.getUsername(), this.getPassword(), this.retryPolicy.createRetryPolicy(), LogManager.getLogger(((Object)((Object)this)).getClass())).createWorkItemRestClient();
        this.revisionFetcher = new TfsWorkItemRevisionFetcher(this.workItemRestClient);
        try {
            this.fieldNameToReferenceNameMapping = this.workItemRestClient.getFieldDefinitions().getNameToReferenceNameMapping();
            this.checkCustomFields();
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Failed to fetch field name to reference name mapping", e);
        }
        this.determineStandardFieldTypeMappings();
    }

    private void determineStandardFieldTypeMappings() {
        this.addFieldTypeMapping("created", EKeyedObjectType.DATE);
        this.addFieldTypeMapping("updated", EKeyedObjectType.DATE);
    }

    private void checkCustomFields() {
        for (String fieldName : this.customFields.extractFirstList()) {
            if (this.getFieldReferenceName(fieldName) != null) continue;
            LOGGER.warn(String.format("The custom field '%s' does not exist in the repository", fieldName));
        }
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        long afterTimestamp = Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp);
        List<String> ids = this.getWorkItemIds(afterTimestamp, 0L);
        UnmodifiableIterator partitions = Iterators.partition(ids.iterator(), (int)150);
        PairList<T, String> issues = new PairList<T, String>();
        while (partitions.hasNext()) {
            String idString = String.join((CharSequence)",", (Iterable)partitions.next());
            try {
                List<Object> workItems = this.shouldFetchRelations() ? this.workItemRestClient.getWorkItemsWithRelations(idString).getWorkItems() : this.workItemRestClient.getWorkItems(idString, this.getFieldsQueryString()).getWorkItems();
                workItems = workItems.stream().filter(item -> item.getUpdatedOnTimestamp() > afterTimestamp).toList();
                issues.addAll(this.retrieveConvertedIssueHistory(workItems, lastScanTimestamp, startTimestamp));
            }
            catch (ServiceCallException e) {
                throw new BugTrackerException("Retrieving the work items from the repository failed.", e);
            }
        }
        issues = this.withAdditionalUpdatedItems(lastScanTimestamp, issues);
        return this.resultBuilder().addItemsWithAuthor(issues).addDeletions(this.performCleanupIfNecessary()).build();
    }

    private Map<TeamscaleIssueId, Long> performCleanupIfNecessary() throws BugTrackerException, StorageException {
        return new WorkItemCleaner(this.getWorkItemIndex(), this.getIssueHistoryIndex(), this.connectorId, this.cleanupStrategy).performCleanupIfNecessary(this.getCurrentImportStart(), () -> new HashSet<String>(this.getWorkItemIds(-1L, 0L)));
    }

    private List<String> getWorkItemIds(long afterTimestamp, long olderThanId) throws BugTrackerException {
        return TfsWorkItemSynchronizerBase.getWorkItemIds(this.projects, this.filterParameters, this.getItemTypes(), Collections.singletonList("id"), afterTimestamp, olderThanId, this.workItemRestClient);
    }

    @VisibleForTesting
    protected static List<String> getWorkItemIds(Set<String> projects, TfsWorkItemFilterParameters filterParameters, Set<String> itemTypes, List<String> fields, long afterTimestamp, long olderThanId, IWorkItemRestClient workItemRestClient) throws BugTrackerException {
        List ids;
        EntryMessage entryMessage = LOGGER.traceEntry("getWorkItemIds(projects={}, filterParameters={}, itemTypes={}, fields={}, afterTimestamp={}, olderThanId={}, workItemRestClient={})", new Object[]{projects, filterParameters, itemTypes, fields, afterTimestamp, olderThanId, workItemRestClient});
        String wiql = TfsWiqlHelper.createWiqlQueryString(afterTimestamp, olderThanId, projects, filterParameters, itemTypes, fields);
        IWorkItemRestClient.WiqlQuery query = new IWorkItemRestClient.WiqlQuery(wiql);
        try {
            ids = workItemRestClient.getWorkItemIds(query).getWorkItemIds();
            LOGGER.debug("Retrieved {} work items for wiql query {}", (Object)ids.size(), (Object)wiql);
            if (ids.size() == 19999 && !((String)ids.getLast()).equals("0")) {
                String oldestId = (String)ids.getLast();
                ids.addAll(TfsWorkItemSynchronizerBase.getWorkItemIds(projects, filterParameters, itemTypes, fields, 0L, Long.parseLong(oldestId), workItemRestClient));
            }
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Retrieving the ids of all work items failed.", e);
        }
        return (List)LOGGER.traceExit(entryMessage, (Object)ids);
    }

    private String getFieldsQueryString() {
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : this.customFields.extractFirstList()) {
            String referenceName = this.getFieldReferenceName(field);
            if (referenceName == null) continue;
            fields.add(referenceName);
        }
        fields.addAll(Arrays.asList(FIELDS_THAT_ARE_ALWAYS_QUERIED_FROM_TFS));
        return StringUtils.concat(fields, (String)",");
    }

    private String getFieldReferenceName(String nameOrReferenceName) {
        if (this.fieldNameToReferenceNameMapping.containsSecond((Object)nameOrReferenceName)) {
            return nameOrReferenceName;
        }
        if (this.fieldNameToReferenceNameMapping.containsFirst((Object)nameOrReferenceName)) {
            return (String)this.fieldNameToReferenceNameMapping.getSecond((Object)nameOrReferenceName);
        }
        return null;
    }

    private PairList<T, String> retrieveConvertedIssueHistory(List<TfsWorkItem> workItems, long lastScanTimestamp, long startTimestamp) throws BugTrackerException, StorageException {
        EntryMessage entryMessage = LOGGER.traceEntry("retrieveConvertedIssueHistory(workItems={}, lastScanTimestamp={})", new Object[]{workItems, lastScanTimestamp});
        if (!this.includeHistory) {
            PairList result = (PairList)workItems.stream().filter(item -> item.getUpdatedOnTimestamp() > lastScanTimestamp).map(this::convertIssue).collect(PairList.toPairList());
            return (PairList)LOGGER.traceExit(entryMessage, (Object)result);
        }
        Set<String> newIssues = this.filterToUnknownIssuesByExternalId(CollectionUtils.map(workItems, TfsWorkItem::getId));
        PairList result = new PairList();
        for (TfsWorkItem workItem : workItems) {
            List<TfsWorkItem> revisions = this.getRevisionsForWorkItem(workItem);
            boolean isNew = newIssues.contains(workItem.getId());
            long boundaryTimestamp = this.determineBoundaryTimestamp(lastScanTimestamp, startTimestamp, isNew);
            Optional<TfsWorkItem> lowerBoundary = Optional.empty();
            if (isNew) {
                lowerBoundary = revisions.stream().filter(revision -> revision.getUpdatedOnTimestamp() < boundaryTimestamp).max(Comparator.comparingLong(TfsWorkItem::getUpdatedOnTimestamp));
            }
            for (TfsWorkItem revision2 : revisions) {
                if (revision2.getUpdatedOnTimestamp() < boundaryTimestamp) continue;
                result.add(this.convertIssue(revision2));
            }
            lowerBoundary.ifPresent(tfsWorkItem -> result.add(this.convertIssue((TfsWorkItem)tfsWorkItem, boundaryTimestamp)));
        }
        return (PairList)LOGGER.traceExit(entryMessage, (Object)result);
    }

    protected abstract long determineBoundaryTimestamp(long var1, long var3, boolean var5);

    private List<TfsWorkItem> getRevisionsForWorkItem(TfsWorkItem workItem) throws BugTrackerException {
        List<TfsWorkItem> allRevisions = this.revisionFetcher.getRevisionsForIssue(workItem.getId(), this.getExpandOption());
        LinkedHashMap<Long, TfsWorkItem> deduplicatedItems = new LinkedHashMap<Long, TfsWorkItem>();
        for (TfsWorkItem revision : allRevisions) {
            deduplicatedItems.merge(revision.getUpdatedOnTimestamp(), revision, (r1, r2) -> r1.getRevisionNumber() > r2.getRevisionNumber() ? r1 : r2);
        }
        return new ArrayList<TfsWorkItem>(deduplicatedItems.values());
    }

    private String getExpandOption() {
        if (this.shouldFetchRelations()) {
            return "relations";
        }
        return null;
    }

    protected PairList<T, String> withAdditionalUpdatedItems(long lastScanTimestamp, PairList<T, String> issueUpdates) throws BugTrackerException, StorageException {
        return issueUpdates;
    }

    protected abstract boolean shouldFetchRelations();

    private Pair<T, String> convertIssue(TfsWorkItem issue) {
        return this.convertIssue(issue, 0L);
    }

    private Pair<T, String> convertIssue(TfsWorkItem issue, long overrideUpdateTimestamp) {
        String id = issue.getId();
        String subject = issue.getTitle();
        String description = issue.getDescriptionOrStepsToReproduce();
        String status = issue.getStatus();
        String assignee = issue.getAssignee();
        String author = issue.getAuthor();
        long created = issue.getCreatedTimestamp();
        long updated = issue.getUpdatedOnTimestamp();
        if (overrideUpdateTimestamp > 0L) {
            updated = overrideUpdateTimestamp;
        }
        boolean closed = this.closedStates.contains(status);
        String issueUrl = issue.createWorkItemLink(this.getUrl());
        List additionalFieldNames = this.customFields.extractFirstList();
        if (!additionalFieldNames.contains(WORK_ITEM_TYPE_FIELD_NAME)) {
            additionalFieldNames.add(WORK_ITEM_TYPE_FIELD_NAME);
        }
        List<String> additionalFieldValues = this.getAdditionalFieldValues(issue, additionalFieldNames);
        String parentId = issue.getParentId();
        TeamscaleIssue teamscaleIssue = new TeamscaleIssue(new TeamscaleIssueId(this.connectorId, id), subject, assignee, author, description, created, updated, status, closed, issueUrl, additionalFieldNames, additionalFieldValues, parentId);
        return new Pair(this.createIssue(teamscaleIssue, issue, this.getAdditionalFieldValue(issue, WORK_ITEM_TYPE_FIELD_NAME)), (Object)issue.getChangedBy());
    }

    private List<String> getAdditionalFieldValues(TfsWorkItem issue, List<String> customFieldNames) {
        return CollectionUtils.map(customFieldNames, fieldName -> this.getAdditionalFieldValue(issue, (String)fieldName));
    }

    private String getAdditionalFieldValue(TfsWorkItem issue, String fieldName) {
        Map fields = issue.getFields();
        String referenceName = this.getFieldReferenceName(fieldName);
        if (referenceName == null || !fields.containsKey(referenceName)) {
            return null;
        }
        return (String)fields.get(referenceName);
    }

    protected abstract T createIssue(TeamscaleIssue var1, TfsWorkItem var2, String var3);

    protected abstract Set<String> getItemTypes();
}

