/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.critical_changes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.MergeRequestChangedMethod;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class MergeRequestCriticalChangeLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UniformPath uniformFilePath;
    private final String methodName;
    private final int methodStartOffset;
    private final int methodEndOffset;
    private int methodStartLine = -1;
    private int methodEndLine = -1;
    private final @Nullable UniformPath originPath;

    private MergeRequestCriticalChangeLocation(@JsonProperty(value="uniformFilePath") UniformPath uniformFilePath, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="methodStartOffset") int methodStartOffset, @JsonProperty(value="methodEndOffset") int methodEndOffset) {
        this(uniformFilePath, methodName, methodStartOffset, methodEndOffset, null);
    }

    @JsonCreator
    private MergeRequestCriticalChangeLocation(@JsonProperty(value="uniformFilePath") UniformPath uniformFilePath, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="methodStartOffset") int methodStartOffset, @JsonProperty(value="methodEndOffset") int methodEndOffset, @JsonProperty(value="originPath") @Nullable UniformPath originPath) {
        this.uniformFilePath = uniformFilePath;
        this.methodName = methodName;
        this.methodStartOffset = methodStartOffset;
        this.methodEndOffset = methodEndOffset;
        this.originPath = originPath;
    }

    @JsonGetter(value="isMethodLocation")
    public boolean isMethodLocation() {
        return this.methodName != null;
    }

    @JsonGetter(value="fullLocationName")
    public String getFullLocationName() {
        if (this.methodName != null) {
            return String.valueOf(this.uniformFilePath) + "#" + this.methodName + "(\u2026)";
        }
        return this.uniformFilePath.toString();
    }

    public UniformPath getUniformPath() {
        return this.uniformFilePath;
    }

    public @Nullable UniformPath getOriginPath() {
        return this.originPath;
    }

    public static MergeRequestCriticalChangeLocation forChangedFile(UniformPath uniformFilePath) {
        return new MergeRequestCriticalChangeLocation(uniformFilePath, null, -1, -1);
    }

    public static MergeRequestCriticalChangeLocation forChangedFile(UniformPath uniformFilePath, @Nullable UniformPath originPath) {
        return new MergeRequestCriticalChangeLocation(uniformFilePath, null, -1, -1, originPath);
    }

    public static MergeRequestCriticalChangeLocation forChangedMethod(MergeRequestChangedMethod changedMethod, @Nullable UniformPath originPath) {
        return MergeRequestCriticalChangeLocation.forChangedMethod(changedMethod.location().getUniformPath(), changedMethod.methodName(), changedMethod.location().getRegion().getStart(), changedMethod.location().getRegion().getEnd(), originPath);
    }

    public static MergeRequestCriticalChangeLocation forChangedMethod(UniformPath uniformFilePath, String methodName, int methodStartOffset, int methodEndOffset, @Nullable UniformPath originPath) {
        return new MergeRequestCriticalChangeLocation(uniformFilePath, methodName, methodStartOffset, methodEndOffset, originPath);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MergeRequestCriticalChangeLocation)) {
            return false;
        }
        MergeRequestCriticalChangeLocation that = (MergeRequestCriticalChangeLocation)o;
        return this.methodStartOffset == that.methodStartOffset && this.methodEndOffset == that.methodEndOffset && Objects.equals(this.uniformFilePath, that.uniformFilePath) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.originPath, that.originPath);
    }

    public int hashCode() {
        return Objects.hash(this.uniformFilePath, this.methodName, this.methodStartOffset, this.methodEndOffset, this.originPath);
    }

    public String toString() {
        return this.getFullLocationName();
    }

    public int getMethodStartOffset() {
        return this.methodStartOffset;
    }

    public int getMethodEndOffset() {
        return this.methodEndOffset;
    }

    public void setMethodLineRange(LineOffsetConverter lineOffsetConverter) {
        this.methodStartLine = lineOffsetConverter.getLine(this.methodStartOffset);
        this.methodEndLine = lineOffsetConverter.getLine(this.methodEndOffset);
    }

    public int getMethodStartLine() {
        return this.methodStartLine;
    }

    public int getMethodEndLine() {
        return this.methodEndLine;
    }
}

