/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.monitoring.prometheus;

import com.teamscale.commons.service.EMimeType;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.option.OptionScheduledRunnable;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.monitoring.prometheus.PrometheusMetricsExportUtils;
import com.teamscale.index.monitoring.prometheus.PrometheusPushMetricsOption;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.expositionformats.ExpositionFormats;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class PrometheusMetricsUploader
extends OptionScheduledRunnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String instanceName;

    public static void setInstanceName(@Nullable String instanceName) {
        PrometheusMetricsUploader.instanceName = StringUtils.emptyIfNull((String)instanceName);
    }

    public void run() {
        try {
            PrometheusPushMetricsOption option = (PrometheusPushMetricsOption)this.getTriggeringOption(PrometheusPushMetricsOption.class);
            PrometheusMetricsUploader.sendMetrics(option, (ServerOptionIndex)this.getIndexLayer().openGlobalIndex(ServerOptionIndex.class));
        }
        catch (ServiceCallException | StorageException e) {
            LOGGER.error("Failed to upload monitoring data to prometheus.", e);
        }
    }

    static void sendMetrics(PrometheusPushMetricsOption option, ServerOptionIndex serverOptionIndex) throws ServiceCallException, StorageException {
        boolean shadowMode = ShadowModeOption.isShadowModeEnabled((ServerOptionIndex)serverOptionIndex);
        String metrics = PrometheusMetricsExportUtils.writePrometheusMetrics((ExpositionFormatWriter)ExpositionFormats.init().getPrometheusTextFormatWriter(), instanceName, serverOptionIndex);
        if (option.enableDifferentServerForStaging && shadowMode) {
            PrometheusMetricsUploader.sendMetrics(option.stagingUrl, option.pushSecretStaging, metrics);
        } else {
            PrometheusMetricsUploader.sendMetrics(option.productionUrl, option.pushSecretProduction, metrics);
        }
    }

    private static void sendMetrics(String url, String secret, String metrics) throws ServiceCallException {
        OkHttpClient client = Retrofit.builder((String)url).withBearerAuthentication(secret).withInteractionLogger(LOGGER).buildOkHttpClient();
        try (Response ignored = client.newCall(new Request.Builder().url(url).post(RequestBody.create((String)metrics, (MediaType)MediaType.parse((String)EMimeType.PLAIN.getType()))).build()).execute();){
            LOGGER.info("Successfully pushed Prometheus metrics to webserver.");
        }
        catch (IOException e) {
            throw new ServiceCallException("Could not push Prometheus metrics to configured webserver: " + e.getMessage(), (Throwable)e);
        }
    }
}

