/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.IImageUsingSlide;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ImageSlide
extends ReportSlideBase<ImageSlideParameters, ImageSlideResult>
implements IImageUsingSlide {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.IMAGE;
    }

    @Override
    public List<String> getUsedImageIds() {
        return Collections.singletonList(((ImageSlideParameters)this.getSlideParameters()).getImageId());
    }

    @IndexValueClass(containedInBackup=true)
    public static class ImageSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @JsonProperty(value="imageId")
        @SlideParameter(formattedName="Image", type=ESlideOptionType.IMAGE_UPLOAD, inputHint="Pasting an image directly into the slide is possible, too")
        private String imageId = "";
        @JsonProperty(value="fitToSlideWidth")
        @SlideParameter(formattedName="Fit to slide width", type=ESlideOptionType.BOOLEAN)
        private boolean fitToSlideWidth;
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        @JsonProperty(value="comments")
        private List<ISlideComment> comments;

        @JsonCreator
        ImageSlideParameters() {
        }

        public ImageSlideParameters(String slideTitle, String imageId, List<ISlideComment> comments, boolean fitToSlideWidth) {
            this.slideTitle = slideTitle;
            this.imageId = imageId;
            this.comments = comments;
            this.fitToSlideWidth = fitToSlideWidth;
        }

        public String getImageId() {
            return this.imageId;
        }

        public void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            return Collections.emptyList();
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class ImageSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY_IMAGE_PATH = "imagePath";
        private static final String PROPERTY_COMMENTS = "comments";
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;
        @JsonProperty(value="imagePath")
        private String imagePath;

        @JsonCreator
        public ImageSlideResult(@JsonProperty(value="comments") List<SlideCommentRenderData> comments, @JsonProperty(value="imagePath") String imagePath) {
            this.comments = comments;
            this.imagePath = imagePath;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public List<SlideCommentRenderData> getComments() {
            return this.comments;
        }
    }
}

