/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.quality_report.slides.TestGapSlidePartitionSelector;
import com.teamscale.index.quality_report.slides.TreeMapOutlineOptions;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class TestGapTreemapSlide
extends ReportSlideBase<TestGapTreemapSlideParameters, TestGapTreemapSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.TEST_GAP_TREEMAP;
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum ETreemapDisplayMode {
        DEFAULT("All methods & test gaps"),
        SHOW_EXECUTION("All methods & coverage"),
        HIDE_UNCHANGED_METHODS("Changed methods & test gaps");

        @JsonProperty(value="uiLabel")
        private final String uiLabel;

        private ETreemapDisplayMode(String uiLabel) {
            this.uiLabel = uiLabel;
        }

        public String getUiLabel() {
            return this.uiLabel;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TreemapWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="treemap")
        private TgaMethodTreeMapNode treemap;
        @JsonProperty(value="stateCounter")
        private CounterSet<ETestGapState> stateCounter;
        @JsonProperty(value="ratio")
        private double ratio;
        @JsonProperty(value="usedPartitions")
        private List<String> usedPartitions;
        @JsonProperty(value="usedCrossAnnotationProjects")
        private Collection<String> usedCrossAnnotationProjects;
        @JsonProperty(value="baseline")
        private long baseline;

        public TreemapWrapper() {
        }

        public TreemapWrapper(TgaMethodTreeMapNode treemap, CounterSet<ETestGapState> stateCounter, double ratio, List<String> usedPartitions, Collection<PublicProjectId> usedCrossAnnotationProjects, long baseline) {
            this.treemap = treemap;
            this.stateCounter = stateCounter;
            this.ratio = ratio;
            this.usedPartitions = usedPartitions;
            this.usedCrossAnnotationProjects = CollectionUtils.map(usedCrossAnnotationProjects, ProjectIdBase::toString);
            this.baseline = baseline;
        }

        public TgaMethodTreeMapNode getTreemap() {
            return this.treemap;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TestGapTreemapSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="treemapWrapper")
        private TreemapWrapper treemapWrapper;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public TestGapTreemapSlideResult() {
        }

        public TestGapTreemapSlideResult(TreemapWrapper treemapWrapper, List<SlideCommentRenderData> comments) {
            this.treemapWrapper = treemapWrapper;
            this.comments = comments;
        }

        public TreemapWrapper getTreemapWrapper() {
            return this.treemapWrapper;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TestGapTreemapSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="projectBranchPath")
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        private ProjectBranchPath projectBranchPath;
        @JsonProperty(value="slideTitle")
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        private String slideTitle;
        @JsonProperty(value="partitionSelector")
        @SlideParameter(formattedName="Coverage sources", type=ESlideOptionType.PARTITION_SELECTOR)
        private TestGapSlidePartitionSelector partitionSelector;
        @JsonProperty(value="treemapDisplayMode")
        @SlideParameter(formattedName="Display mode", type=ESlideOptionType.ONE_OF_ENUM_SELECTION)
        private ETreemapDisplayMode treemapDisplayMode = ETreemapDisplayMode.DEFAULT;
        @JsonProperty(value="outlineOptions")
        @SlideParameter(formattedName="Outline options", type=ESlideOptionType.TREEMAP_OUTLINE_OPTIONS)
        private @Nullable TreeMapOutlineOptions outlineOptions;
        @JsonProperty(value="hidePercentageBadge")
        @SlideParameter(formattedName="Hide Percentage Badge", type=ESlideOptionType.BOOLEAN)
        private boolean hidePercentageBadge = false;
        @JsonProperty(value="comments")
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        private List<ISlideComment> comments;

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public TestGapSlidePartitionSelector getPartitionSelector() {
            return this.partitionSelector;
        }

        public ETreemapDisplayMode getTreemapDisplayMode() {
            return this.treemapDisplayMode;
        }

        public @Nullable TreeMapOutlineOptions getOutlineOptions() {
            return this.outlineOptions;
        }
    }
}

