/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.external.input.external_storage.migration.MigratedArchivePathsIndex;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.ReportMappingSupport;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.RepositoryNeedsRescheduleException;
import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreCommitTreeUpdater;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorBaseParameters;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.GlobalArchiveContentIndexBase;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import com.teamscale.index.repository.artifact_store.RemoteArtifactStoreRevisionCollector;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.Predicates;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public abstract class ArtifactStoreRepositoryConnectionBase<T extends ArtifactStoreRepositoryInfoBase, S extends SimpleArtifactStoreClientBase<T>>
extends RepositoryConnectionBase {
    private static final int PROCESSED_ARTIFACTS_PER_BATCH = 5;
    private static final Logger LOGGER = LogManager.getLogger();
    private final T repositoryInfo;
    private final IArtifactStoreCommitResolver commitResolver;
    private final ReportMappingSupport reportMappingSupport;
    private final long startTimestamp;
    private final long endTimestamp;
    protected final IProfilingMonitor profilingMonitor;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final SupplierWithException<S, ProjectConfigurationException> client;
    private final MigratedArchivePathsIndex migratedArchivePathsIndex;

    protected ArtifactStoreRepositoryConnectionBase(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, ArtifactStoreRepositoryConnectorBaseParameters artifactStoreRepositoryConnectorBaseParameters, T repositoryInfo, IProfilingMonitor profilingMonitor, ReportMappingSupport reportMappingSupport, FunctionWithException<T, S, ProjectConfigurationException> clientCreator, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        super(connectorBaseParameterStep);
        this.repositoryInfo = repositoryInfo;
        this.reportMappingSupport = reportMappingSupport;
        this.commitResolver = ((ArtifactStoreRepositoryInfoBase)repositoryInfo).createCommitResolver(connectorBaseParameterStep.getConnectionIdentifier());
        this.startTimestamp = this.getInstantForStartDateOrRevision(connectorBaseParameterStep.getStartDateOrRevision(), connectorBaseParameterStep.getMinimalStartTimestamp()).toEpochMilli();
        this.endTimestamp = this.getInstantForEndDateOrRevision(connectorBaseParameterStep.getEndDateOrRevision()).toEpochMilli();
        this.profilingMonitor = profilingMonitor;
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.client = SupplierWithException.memoize(() -> (SimpleArtifactStoreClientBase)clientCreator.apply(repositoryInfo));
        this.migratedArchivePathsIndex = artifactStoreRepositoryConnectorBaseParameters.getMigratedArchivePathsIndex();
    }

    @Override
    protected Optional<Long> convertRevisionToTimestamp(String revision) throws RepositoryException {
        return this.commitResolver.resolveCommit(revision, this.getDefaultBranchName()).map(CommitDescriptor::getTimestamp);
    }

    @Override
    public String getLocationDescription() {
        return StringUtils.ensureEndsWith((String)((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getExternalCredentials().uri, (String)"/") + ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getRepositoryOrBucketName();
    }

    protected abstract String getArtifactStoreType();

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(IChangeRetrieverCommitTree commitTree) throws RepositoryException, RescheduleRequestedException {
        try {
            this.profilingMonitor.startProfiling("Remote list artifacts");
            ItemQueryResultData itemQueryResultData = ((SimpleArtifactStoreClientBase)this.client.get()).findItems(this.repositoryInfo, this.getPollingIntervalSeconds());
            this.updateTotalArtifactStoreSizeMonitoring(itemQueryResultData);
            List<ArtifactStoreItemData> dataItems = itemQueryResultData.results;
            LOGGER.info("Fetched {} items.", (Object)dataItems.size());
            List<ArtifactStoreItemData> filteredDataItems = this.filterDataItems(dataItems);
            this.profilingMonitor.stopProfiling("Remote list artifacts");
            if (filteredDataItems.isEmpty()) {
                Level logLevel = ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).isExternalStorage() ? Level.INFO : Level.WARN;
                LOGGER.log(logLevel, "The provided search patterns did not match any items in the artifact store");
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter debugWriter = new PrintWriter(stringWriter);
            this.profilingMonitor.startProfiling("Integrate into commit tree");
            RemoteExternalDataRevisions remoteRevisions = this.getRemoteArtifactStoreRevisions(filteredDataItems, debugWriter);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = remoteRevisions::getRevisionDump;
            LOGGER.debug("RemoteArtifactStoreRevisions before pruning revisions:\n{}", supplierArray);
            remoteRevisions.pruneRevisions(this.getDefaultBranchName(), this.startTimestamp, this.endTimestamp);
            remoteRevisions.discardRevisionsMissingRequiredZipFiles(((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getRequiredZipFilePatterns(), debugWriter);
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = remoteRevisions::getRevisionDump;
            LOGGER.debug("RemoteArtifactStoreRevisions after pruning revisions:\n{}", supplierArray2);
            this.updateAnalyzedArtifactStoreSizeMonitoring(remoteRevisions);
            Set<ICommitTreeNode> addedNodes = new ArtifactStoreCommitTreeUpdater<ArchiveIndexBase>(commitTree, this.getArchiveIndex(), ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getBranchAnalysisStateIndex(), this.getLowerTimestampBoundaryForChanges()).updateCommitTree(remoteRevisions, itemQueryResultData.getScanType());
            this.profilingMonitor.stopProfiling("Integrate into commit tree");
            debugWriter.close();
            ((ArchiveIndexBase)((Object)((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getArchiveIndex())).storeDebugInfo(stringWriter.toString());
            return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).withAddedNodes(addedNodes).build();
        }
        catch (ProjectConfigurationException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    private @NonNull List<ArtifactStoreItemData> filterDataItems(List<ArtifactStoreItemData> dataItems) {
        List<ArtifactStoreItemData> includedArtifacts = ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getKeyIncludeExcludePatterns().filterArtifacts(dataItems);
        if (!((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).isExternalStorage()) {
            return includedArtifacts;
        }
        return CollectionUtils.filter(includedArtifacts, Predicate.not(Predicates.or(this::wasMigrated, ArtifactStoreItemData::isMetadata)));
    }

    private boolean wasMigrated(ArtifactStoreItemData item) {
        try {
            boolean wasMigrated = this.migratedArchivePathsIndex.wasMigrated(item.getFullPath());
            if (wasMigrated) {
                LOGGER.debug("Ignoring item with full path '{}' as it was migrated.", (Object)item.getFullPath());
            } else {
                LOGGER.debug("Item with full path '{}' was not migrated and will be imported.", (Object)item.getFullPath());
            }
            return wasMigrated;
        }
        catch (StorageException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to check if '{}' was migrated. This archive will be integrated, but may cause a rollback.", (Object)item.getFullPath());
            return false;
        }
    }

    private void updateTotalArtifactStoreSizeMonitoring(ItemQueryResultData itemQueryResultData) throws StorageException {
        long allRemoteItemsContentSize = itemQueryResultData.stream().mapToLong(ArtifactStoreItemData::getContentLength).sum();
        this.getArchiveIndex().storeTotalArtifactStoreSize(allRemoteItemsContentSize);
    }

    private void updateAnalyzedArtifactStoreSizeMonitoring(RemoteExternalDataRevisions remoteRevisions) throws StorageException {
        long analyzedContentSize = remoteRevisions.sizeByRevision.values().stream().mapToLong(l -> l).sum();
        this.getArchiveIndex().storeAnalyzedArtifactStoreSize(analyzedContentSize);
    }

    private RemoteExternalDataRevisions getRemoteArtifactStoreRevisions(List<ArtifactStoreItemData> items, PrintWriter debugWriter) throws RepositoryException, RescheduleRequestedException {
        return RemoteArtifactStoreRevisionCollector.collectRevisions(debugWriter, this.repositoryInfo, this.commitResolver, items, this.getDefaultBranchName(), this::isBranchNameIncludedOrDefaultBranch);
    }

    private long getLowerTimestampBoundaryForChanges() {
        return ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getIgnoreChangesOlderThanDays().map(days -> DateTimeUtils.now().minus(Duration.ofDays(days.intValue()))).orElse(Instant.EPOCH).toEpochMilli();
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        try {
            if (this.revisionMissingInIndex(revision)) {
                LOGGER.error("Downloading all archives for revision {} failed! Handling as empty upload.", (Object)revision);
                return null;
            }
            if (this.revisionMissingInIndex(parentRevision)) {
                LOGGER.error("Downloading all archives for parent revision {} of revision {} failed! This should never happen, as failed revisions are skipped!", (Object)parentRevision, (Object)revision);
                return null;
            }
            Map<String, byte[]> currentContentHashes = this.getArchiveIndex().getAllPathsForRevision(revision);
            Map<String, byte[]> parentContentHashes = this.getArchiveIndex().getAllPathsForRevision(parentRevision);
            return this.buildChangeSet(revision, currentContentHashes, parentContentHashes);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean supportsSkipping() {
        return true;
    }

    private ArchiveIndexBase getArchiveIndex() {
        return ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getArchiveIndex();
    }

    private GlobalArchiveContentIndexBase getGlobalArchiveContentIndex() {
        return ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getGlobalArchiveContentIndex();
    }

    @Override
    public boolean shouldInheritForkInformation() {
        return true;
    }

    private RepositoryChangeSet buildChangeSet(CommitTreeRevision commitTreeRevision, Map<String, byte[]> currentContent, Map<String, byte[]> parentContent) throws RepositoryException {
        String branchName;
        String revision = commitTreeRevision.getRevision();
        Optional<CommitDescriptor> resolvedCommit = this.commitResolver.resolveCommit(revision, branchName = commitTreeRevision.getBranchName());
        if (resolvedCommit.isEmpty()) {
            LOGGER.error("Unable to build change set for revision {} and branch name {} because timestamp was previously unresolved.", (Object)revision, (Object)branchName);
            return null;
        }
        String message = this.getArtifactStoreType() + " import of " + revision;
        RepositoryChangeSet repositoryChangeset = new RepositoryChangeSet(revision, resolvedCommit.get(), "Teamscale", message, this.getCodePatternSupport(), 0L);
        for (String path : CollectionUtils.differenceSet(currentContent.keySet(), (Collection[])new Collection[]{parentContent.keySet()})) {
            repositoryChangeset.addChange(path, ERepositoryChangeType.ADD);
        }
        for (String path : CollectionUtils.differenceSet(parentContent.keySet(), (Collection[])new Collection[]{currentContent.keySet()})) {
            repositoryChangeset.addChange(path, ERepositoryChangeType.DELETE);
        }
        for (String path : CollectionUtils.intersectionSet(parentContent.keySet(), (Collection[])new Collection[]{currentContent.keySet()})) {
            byte[] newHash;
            byte[] oldHash;
            if (!this.wasUpdated(path, oldHash = parentContent.get(path), newHash = currentContent.get(path))) continue;
            repositoryChangeset.addChange(path, ERepositoryChangeType.EDIT);
        }
        return repositoryChangeset;
    }

    private boolean wasUpdated(String path, byte[] oldHash, byte[] newHash) throws RepositoryException {
        try {
            if (!Arrays.equals(oldHash, newHash)) {
                return true;
            }
            Optional<EReportFormat> reportFormat = this.reportMappingSupport.determineReportFormat(UniformPathCompatibilityUtil.convert((String)path));
            return reportFormat.filter(r -> r.containsCoverage() || r.containsTestExecutions()).isPresent();
        }
        catch (ConQATException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) throws RepositoryException {
        try {
            if (this.revisionMissingInIndex(revision)) {
                LOGGER.error("Downloading all archives for revision {} failed! Handling as empty archive.", (Object)revision);
                return Collections.emptySet();
            }
            return this.getArchiveIndex().getAllPathsForRevision(revision).keySet();
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private boolean revisionMissingInIndex(CommitTreeRevision revision) throws StorageException {
        List<String> archives = this.getArchiveIndex().getArchivesForRevision(revision);
        try {
            Optional result = (Optional)this.parallelTaskExecutor.computeInParallelBatches(archives, archiveBatch -> this.revisionMissingInIndexBatch(revision, (List<String>)archiveBatch), Collectors.reducing((a, b) -> a != false || b != false));
            return result.orElse(false);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private boolean revisionMissingInIndexBatch(CommitTreeRevision revision, List<String> archiveBatch) throws StorageException, RepositoryException {
        for (String archive : archiveBatch) {
            if (this.ensureArchiveInIndex(archive, revision)) continue;
            return true;
        }
        return false;
    }

    private boolean ensureArchiveInIndex(String archive, CommitTreeRevision revision) throws StorageException, RepositoryException {
        if (this.getArchiveIndex().isArchiveFailed(archive)) {
            return false;
        }
        if (this.getArchiveIndex().isArchiveProcessed(archive)) {
            return true;
        }
        return this.downloadAndStoreArchive(archive, revision, true);
    }

    private boolean downloadAndStoreArchive(String archive, CommitTreeRevision revision, boolean shouldCleanupArchiveIndexOnFailure) throws StorageException, RepositoryNeedsRescheduleException {
        ArrayList<String> successfullyAddedPaths = new ArrayList<String>();
        try {
            String prefix = ((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).determineFilePrefix(archive).orElse("");
            AtomicInteger containedEntries = new AtomicInteger(0);
            this.profilingMonitor.startProfiling("Download and store artifact");
            ((SimpleArtifactStoreClientBase)this.client.get()).forEachEntryInArchive(((ArtifactStoreRepositoryInfoBase)this.repositoryInfo).getRepositoryOrBucketName(), archive, (zis, zipEntry) -> this.processAndStoreArchiveEntry(revision, (ArchiveInputStream<?>)zis, (ArchiveEntry)zipEntry, prefix, archive, containedEntries, (List<String>)successfullyAddedPaths));
            this.getArchiveIndex().setArchiveProcessed(archive, containedEntries.get());
            this.profilingMonitor.stopProfiling("Download and store artifact");
            return true;
        }
        catch (ProjectConfigurationException | RepositoryException e) {
            LOGGER.error("Downloading of {} failed: {} Will retry at next invocation in a few minutes.", (Object)archive, (Object)e.getMessage(), (Object)e);
            if (!shouldCleanupArchiveIndexOnFailure) {
                successfullyAddedPaths.clear();
            }
            this.getArchiveIndex().setArchiveFailed(archive, revision, successfullyAddedPaths);
            throw new RepositoryNeedsRescheduleException(e);
        }
    }

    private void processAndStoreArchiveEntry(CommitTreeRevision revision, ArchiveInputStream<?> archiveInputStream, ArchiveEntry archiveEntry, String prefix, String archiveName, AtomicInteger containedEntries, List<String> successfullyAddedPaths) throws IOException, StorageException {
        String path = UniformPathUtils.cleanPath((String)UniformPathUtils.concatenate((String[])new String[]{prefix, archiveEntry.getName()}));
        if (!this.isIncluded(path)) {
            return;
        }
        try {
            byte[] content = FileSystemUtils.readStreamBinary(archiveInputStream);
            if (!LZ4Utils.isCompressibleSize((long)content.length)) {
                ArtifactStoreRepositoryConnectionBase.logFileTooBigWarning(archiveName, path);
                return;
            }
            containedEntries.incrementAndGet();
            this.profilingMonitor.startProfiling("compress and store artifact in index");
            this.getArchiveIndex().setContent(revision, path, content, this.getGlobalArchiveContentIndex());
            this.profilingMonitor.stopProfiling("compress and store artifact in index");
        }
        catch (OutOfMemoryError e) {
            ArtifactStoreRepositoryConnectionBase.logFileTooBigWarning(archiveName, path);
        }
        successfullyAddedPaths.add(path);
    }

    private static void logFileTooBigWarning(String archiveName, String path) {
        LOGGER.warn("File '{}' from zip file '{}' is too big to be handled by Teamscale, skipping.", (Object)path, (Object)archiveName);
    }

    @Override
    public IStreamWithException<byte[], RepositoryException> getContent(List<String> paths, CommitTreeRevision revision) throws RepositoryException {
        IStreamWithException pathBatches = IStreamWithException.of((IStreamSource)IStreamSource.ofIterable(paths, RepositoryException.class)).batch(5);
        return pathBatches.map(batch -> {
            try {
                return this.getArchiveIndex().getContent(revision, (List<String>)batch, this.getGlobalArchiveContentIndex(), (ConsumerWithTwoExceptions<String, StorageException, RepositoryException>)((ConsumerWithTwoExceptions)archive -> this.reDownloadMissingContent(revision, (String)archive)));
            }
            catch (StorageException e) {
                throw new RepositoryException((Throwable)e);
            }
        }).flatMap(list -> IStreamWithException.of((IStreamSource)IStreamSource.ofIterable((Iterable)list, RepositoryException.class)));
    }

    private void reDownloadMissingContent(CommitTreeRevision revision, String archive) throws StorageException, RepositoryException {
        try {
            this.downloadAndStoreArchive(archive, revision, false);
        }
        catch (RepositoryNeedsRescheduleException e) {
            if (this.getArchiveIndex().isArchiveFailed(archive)) {
                String branchName = revision.getBranchName();
                Optional<CommitDescriptor> commitDescriptor = this.commitResolver.resolveCommit(revision.getRevision(), branchName);
                if (commitDescriptor.isEmpty()) {
                    LOGGER.error("Detected archive missing on server: {}. Cannot perform automatic rollback to this commit, since timestamp resolution failed. Please trigger a rollback manually, so the change retriever can pick this up.", (Object)archive);
                    throw e;
                }
                CommitDescriptor rollbackTarget = commitDescriptor.get().cloneWithDecrementedTimestamp();
                String logMessage = "Detected archive missing on server: " + archive + ". Performing rollback to " + String.valueOf(rollbackTarget) + ".";
                LOGGER.error(logMessage, (Throwable)((Object)e));
                throw new RepositoryNeedsRollbackException(logMessage, Map.of(branchName, rollbackTarget.getTimestamp() - 1L));
            }
            throw e;
        }
    }

    @Override
    protected byte[] getContent(String path, CommitTreeRevision revision) throws RepositoryException {
        return super.getContent(path, revision);
    }

    @Override
    public void close() throws RepositoryException {
        try {
            this.commitResolver.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        return new Pair((Object)"Teamscale", (Object)(this.getArtifactStoreType() + " import of " + revision.getRevision()));
    }

    @Override
    public String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        return null;
    }

    @Override
    public boolean isCodeRepository() {
        return false;
    }

    public static class RemoteExternalDataRevisions {
        private final SetMap<ArtifactStoreRevision, String> pathsByRevision = new SetMap();
        private final Map<ArtifactStoreRevision, Long> sizeByRevision = new HashMap<ArtifactStoreRevision, Long>();

        @VisibleForTesting
        public void insertRevisionAndPath(ArtifactStoreRevision artifactStoreRevision, String fullPath, long size) {
            this.pathsByRevision.add((Object)artifactStoreRevision, (Object)fullPath);
            this.sizeByRevision.compute(artifactStoreRevision, (key, oldSize) -> oldSize == null ? size : size + oldSize);
        }

        Set<ArtifactStoreRevision> getRevisions() {
            return this.pathsByRevision.getKeys();
        }

        Set<String> getArchivePathsForRevision(ArtifactStoreRevision revision) {
            return (Set)this.pathsByRevision.getCollection((Object)revision);
        }

        private void pruneRevisions(String defaultBranch, long startTimestamp, long endTimestamp) {
            ArtifactStoreRevision latestDefaultBranchRevisionBeforeOrAtStart = null;
            ArrayList entries = new ArrayList(this.pathsByRevision.entrySet());
            entries.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry : entries) {
                ArtifactStoreRevision revision = (ArtifactStoreRevision)entry.getKey();
                if (revision.getTimestamp() > endTimestamp) {
                    this.pathsByRevision.removeCollection((Object)revision);
                    continue;
                }
                if (revision.getBranchName().equals(defaultBranch)) {
                    if (revision.getTimestamp() > startTimestamp) continue;
                    if (latestDefaultBranchRevisionBeforeOrAtStart == null) {
                        latestDefaultBranchRevisionBeforeOrAtStart = revision;
                        continue;
                    }
                    if (latestDefaultBranchRevisionBeforeOrAtStart.getTimestamp() >= revision.getTimestamp()) continue;
                    this.pathsByRevision.removeCollection((Object)latestDefaultBranchRevisionBeforeOrAtStart);
                    latestDefaultBranchRevisionBeforeOrAtStart = revision;
                    continue;
                }
                if (revision.getTimestamp() >= startTimestamp) continue;
                this.pathsByRevision.removeCollection((Object)revision);
            }
        }

        @VisibleForTesting
        void discardRevisionsMissingRequiredZipFiles(List<Pattern> requiredZipFilePatterns, PrintWriter debugWriter) {
            if (requiredZipFilePatterns.isEmpty()) {
                return;
            }
            for (Map.Entry revisionAndPathsEntry : new ArrayList(this.pathsByRevision.entrySet())) {
                if (RemoteExternalDataRevisions.atLeastOnePathMatchesEachPattern((Set)revisionAndPathsEntry.getValue(), requiredZipFilePatterns)) continue;
                ArtifactStoreRevision revision = (ArtifactStoreRevision)revisionAndPathsEntry.getKey();
                debugWriter.println("Excluding revision " + String.valueOf(revision) + " as not all required ZIP files are present.");
                this.pathsByRevision.removeCollection((Object)revision);
            }
        }

        private static boolean atLeastOnePathMatchesEachPattern(Set<String> zipFilePaths, List<Pattern> requiredZipFilePatterns) {
            return requiredZipFilePatterns.stream().allMatch(pattern -> RemoteExternalDataRevisions.atLeastOnePathMatchesPattern(zipFilePaths, pattern));
        }

        private static boolean atLeastOnePathMatchesPattern(Set<String> zipFilePaths, Pattern pattern) {
            return zipFilePaths.stream().map(pattern::matcher).anyMatch(Matcher::find);
        }

        private String getRevisionDump() {
            StringBuilder builder = new StringBuilder();
            for (ArtifactStoreRevision revision : CollectionUtils.sort((Collection)this.pathsByRevision.getKeys())) {
                builder.append(revision.toString());
                for (String path : CollectionUtils.sort((Collection)this.pathsByRevision.getCollection((Object)revision))) {
                    builder.append("\n\t").append(path);
                }
                builder.append("\n\t");
            }
            return builder.toString();
        }
    }

    @VisibleForTesting
    public static class ArtifactStoreRevision
    extends CommitTreeRevision
    implements Comparable<ArtifactStoreRevision> {
        private static final long serialVersionUID = 1L;
        private final long timestamp;

        ArtifactStoreRevision(String revision, CommitDescriptor commit) {
            this(revision, commit.getBranchName(), commit.getTimestamp());
        }

        @VisibleForTesting
        public ArtifactStoreRevision(String revision, String branchName, long timestamp) {
            super(revision, branchName);
            this.timestamp = timestamp;
        }

        public CommitDescriptor getCommitDescriptor() {
            return new CommitDescriptor(this.getBranchName(), this.timestamp);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return super.toString() + ", " + this.timestamp;
        }

        @Override
        public int compareTo(@NonNull ArtifactStoreRevision other) {
            return Comparator.comparing(ArtifactStoreRevision::getTimestamp).thenComparing(CommitTreeRevision::getBranchName).compare(this, other);
        }
    }
}

