/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Index(name="repository-content-cache", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={byte[].class})
public class RepositoryContentCacheIndex
extends IndexBase
implements IGlobalIndex {
    private static final String SEPERATOR = "#-#";
    public static final String INDEX_NAME = "repository-content-cache";

    public RepositoryContentCacheIndex(IStore store) {
        super(store);
    }

    public List<byte @Nullable []> getContent(String revisionIdentifier, List<String> uniformPaths) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (String uniformPath : uniformPaths) {
            keys.add(RepositoryContentCacheIndex.makeKey(revisionIdentifier, uniformPath));
        }
        return this.store.get(keys);
    }

    private static byte[] makeKey(String revisionIdentifier, String uniformPath) {
        return StringUtils.stringToBytes((String)(revisionIdentifier + SEPERATOR + uniformPath));
    }

    public void cacheContent(PairList<UniformPath, byte[]> contentToCache, String revisionIdentifier) throws StorageException {
        PairList valuesToStore = new PairList(contentToCache.size());
        for (Pair pair : contentToCache) {
            byte[] value = (byte[])pair.getSecond();
            if (value == null) continue;
            valuesToStore.add((Object)RepositoryContentCacheIndex.makeKey(revisionIdentifier, ((UniformPath)pair.getFirst()).toStringAsMigrationFrontier()), (Object)value);
        }
        this.store.put(valuesToStore);
    }
}

