/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class GitPreStartCommitsSupport {
    private static final Logger LOGGER = LogManager.getLogger();
    private final GitRepositoryInfoIndex gitInfoIndex;
    private final String defaultBranchName;

    GitPreStartCommitsSupport(GitRepositoryInfoIndex gitInfoIndex, String defaultBranchName) {
        this.gitInfoIndex = gitInfoIndex;
        this.defaultBranchName = defaultBranchName;
    }

    public void addPreStartCommits(Set<RevCommit> commits, Repository repository, List<? extends ICommitTreeNode> oldNodes) throws RepositoryException {
        int numCommitsBefore = commits.size();
        Set<RevCommit> postStartRoots = GitPreStartCommitsSupport.findPostStartRoots(commits);
        try {
            Set<RevCommit> preStartRoots = GitPreStartCommitsSupport.getAllRootParents(postStartRoots);
            commits.addAll(preStartRoots);
            GitPreStartCommitsSupport.restoreOldAncestorsOfPreStartRoots(commits, preStartRoots, oldNodes, repository);
            this.ensureContainsDefaultBranchRoot(commits, postStartRoots, repository);
            GitPreStartCommitsSupport.parseCommits(commits, repository);
        }
        catch (IOException | StorageException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        LOGGER.debug("Added {} pre-start commits.", new Supplier[]{() -> commits.size() - numCommitsBefore});
    }

    private static Set<RevCommit> findPostStartRoots(Set<RevCommit> commitsAfterAnalysisStart) {
        return commitsAfterAnalysisStart.stream().filter(commit -> Arrays.stream(commit.getParents()).anyMatch(Predicate.not(commitsAfterAnalysisStart::contains))).collect(Collectors.toSet());
    }

    private static Set<RevCommit> getAllRootParents(Set<RevCommit> postStartRoots) throws IOException {
        return postStartRoots.stream().map(RevCommit::getParents).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    private static void restoreOldAncestorsOfPreStartRoots(Set<RevCommit> commits, Set<RevCommit> preStartRoots, List<? extends ICommitTreeNode> oldNodes, Repository repository) throws IOException {
        UnmodifiableSet oldRevisions = UnmodifiableSet.of(oldNodes.stream().map(ICommitTreeNode::getRevision).map(CommitTreeRevision::getRevision).collect(Collectors.toSet()));
        ArrayDeque<RevCommit> expansionFrontier = new ArrayDeque<RevCommit>(preStartRoots);
        try (RevWalk revWalk = new RevWalk(repository);){
            while (!expansionFrontier.isEmpty()) {
                RevCommit currentRoot = (RevCommit)expansionFrontier.remove();
                GitPreStartCommitsSupport.parseCommit(currentRoot, revWalk);
                Arrays.stream(currentRoot.getParents()).filter(Predicate.not(commits::contains)).filter(parent -> oldRevisions.contains((Object)parent.getName())).forEach(parent -> {
                    expansionFrontier.add((RevCommit)parent);
                    commits.add((RevCommit)parent);
                });
            }
        }
    }

    private void ensureContainsDefaultBranchRoot(Set<RevCommit> commits, Set<RevCommit> postStartRoots, Repository repository) throws IOException, StorageException {
        RevCommit defaultBranchRootToRestore = this.getDefaultBranchRootToRestore(repository, this.gitInfoIndex);
        if (defaultBranchRootToRestore == null) {
            return;
        }
        GitPreStartCommitsSupport.restoreInitialDefaultBranchRootFromPostStartRoots(commits, postStartRoots, repository, defaultBranchRootToRestore);
        if (!commits.contains(defaultBranchRootToRestore)) {
            this.restoreInitialDefaultBranchRootFromDefaultBranchHead(commits, repository, defaultBranchRootToRestore);
        }
    }

    private @Nullable RevCommit getDefaultBranchRootToRestore(Repository repository, GitRepositoryInfoIndex gitInfoIndex) throws StorageException, IOException {
        Optional<String> defaultBranchRootRevisionAtInitialAnalysis = gitInfoIndex.getInitialDefaultBranchRootRevision();
        if (defaultBranchRootRevisionAtInitialAnalysis.isEmpty()) {
            LOGGER.debug("No default branch root stored yet; use current default branch head as root.");
            return this.resolveCurrentDefaultBranchHead(repository);
        }
        ObjectId defaultBranchHeadAtInitialAnalysisId = repository.resolve(defaultBranchRootRevisionAtInitialAnalysis.get());
        if (defaultBranchHeadAtInitialAnalysisId == null) {
            LOGGER.debug("Default branch root '{}' recorded during initial analysis does not exist; use current default branch head.", defaultBranchRootRevisionAtInitialAnalysis);
            return this.resolveCurrentDefaultBranchHead(repository);
        }
        return repository.parseCommit((AnyObjectId)defaultBranchHeadAtInitialAnalysisId);
    }

    private @Nullable RevCommit resolveCurrentDefaultBranchHead(Repository repository) throws IOException, StorageException {
        String defaultBranchHeadRefName = GitRefUtils.createBranchHeadRefName((String)this.defaultBranchName);
        LOGGER.traceEntry("Resolving current default branch head for ref '{}'.", new Object[]{defaultBranchHeadRefName});
        ObjectId defaultBranchHeadAtInitialAnalysisId = repository.resolve(defaultBranchHeadRefName);
        if (defaultBranchHeadAtInitialAnalysisId == null) {
            LOGGER.warn("Default branch head '{}' does not exist; there are no commits on the default branch.", (Object)defaultBranchHeadRefName);
            return (RevCommit)LOGGER.traceExit((Object)null);
        }
        RevCommit defaultBranchHead = repository.parseCommit((AnyObjectId)defaultBranchHeadAtInitialAnalysisId);
        this.gitInfoIndex.storeInitialDefaultBranchRootRevision(defaultBranchHead.getName());
        return (RevCommit)LOGGER.traceExit((Object)defaultBranchHead);
    }

    private void restoreInitialDefaultBranchRootFromDefaultBranchHead(Set<RevCommit> commits, Repository repository, RevCommit defaultBranchRootToRestore) throws IOException {
        String defaultBranchHeadRefName = GitRefUtils.createBranchHeadRefName((String)this.defaultBranchName);
        ObjectId resolvedId = repository.resolve(defaultBranchHeadRefName);
        if (resolvedId == null) {
            LOGGER.trace("Default branch head '{}' does not exist.", (Object)defaultBranchHeadRefName);
            return;
        }
        RevCommit newDefaultBranchHead = repository.parseCommit((AnyObjectId)resolvedId);
        Set<RevCommit> pathToOldHead = GitPreStartCommitsSupport.getAllNodesBetween((ObjectId)newDefaultBranchHead, (ObjectId)defaultBranchRootToRestore, repository);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = pathToOldHead::size;
        supplierArray[1] = () -> ((RevCommit)newDefaultBranchHead).getName();
        supplierArray[2] = () -> ((RevCommit)defaultBranchRootToRestore).getName();
        LOGGER.trace("Adding {} nodes between new default branch HEAD {} and default branch HEAD {}.", supplierArray);
        commits.addAll(pathToOldHead);
        commits.add(newDefaultBranchHead);
    }

    private static void restoreInitialDefaultBranchRootFromPostStartRoots(Set<RevCommit> commits, Set<RevCommit> postStartRoots, Repository repository, RevCommit oldDefaultBranchHead) throws IOException {
        for (RevCommit postStartRoot : postStartRoots) {
            Set<RevCommit> pathToHead = GitPreStartCommitsSupport.getAllNodesBetween((ObjectId)postStartRoot, (ObjectId)oldDefaultBranchHead, repository);
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = pathToHead::size;
            supplierArray[1] = () -> ((RevCommit)postStartRoot).getName();
            supplierArray[2] = () -> ((RevCommit)oldDefaultBranchHead).getName();
            LOGGER.trace("Adding {} nodes between post-start root {} and default branch HEAD {}.", supplierArray);
            commits.addAll(pathToHead);
        }
    }

    private static Set<RevCommit> getAllNodesBetween(ObjectId startId, ObjectId ancestorId, Repository repository) throws IOException {
        try (RevWalk revWalk = new RevWalk(repository);){
            RevCommit startCommit = revWalk.parseCommit((AnyObjectId)startId);
            RevCommit ancestorCommit = revWalk.parseCommit((AnyObjectId)ancestorId);
            if (startCommit.getCommitTime() < ancestorCommit.getCommitTime()) {
                Set<RevCommit> set = Collections.emptySet();
                return set;
            }
            HashSet<RevCommit> commitsOnPath = new HashSet<RevCommit>();
            HashSet<RevCommit> seenCommits = new HashSet<RevCommit>();
            ArrayDeque<RevCommit> commitsToProcess = new ArrayDeque<RevCommit>();
            commitsToProcess.push(startCommit);
            seenCommits.add(startCommit);
            revWalk.parseHeaders((RevObject)startCommit);
            while (!commitsToProcess.isEmpty()) {
                RevCommit commit = (RevCommit)commitsToProcess.peek();
                List<RevCommit> parents = GitPreStartCommitsSupport.parseHeaders(commit.getParents(), revWalk);
                List parentsToProcess = CollectionUtils.filter(parents, parent -> !seenCommits.contains(parent) && parent.getCommitTime() >= ancestorCommit.getCommitTime());
                seenCommits.addAll(parentsToProcess);
                parentsToProcess.forEach(commitsToProcess::push);
                if (!parentsToProcess.isEmpty()) continue;
                commitsToProcess.pop();
                if (commit.equals((AnyObjectId)startCommit)) {
                    HashSet<RevCommit> hashSet = commitsOnPath;
                    return hashSet;
                }
                if (!commit.equals((AnyObjectId)ancestorCommit)) {
                    if (!parents.stream().anyMatch(commitsOnPath::contains)) continue;
                }
                commitsOnPath.add(commit);
            }
            HashSet<RevCommit> hashSet = commitsOnPath;
            return hashSet;
        }
    }

    private static @NonNull List<RevCommit> parseHeaders(RevCommit[] commits, RevWalk revWalk) throws IOException {
        List<RevCommit> parents = Arrays.asList(commits);
        for (RevCommit parent : parents) {
            revWalk.parseHeaders((RevObject)parent);
        }
        return parents;
    }

    private static void parseCommits(Set<RevCommit> commits, Repository repository) throws IOException {
        try (RevWalk revWalk = new RevWalk(repository);){
            for (RevCommit commit : commits) {
                GitPreStartCommitsSupport.parseCommit(commit, revWalk);
            }
        }
    }

    private static void parseCommit(RevCommit commit, RevWalk revWalk) throws IOException {
        revWalk.parseHeaders((RevObject)commit);
        revWalk.parseBody((RevObject)commit);
    }
}

