/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sca.jfrog;

import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.ESoftwareCompositionAnalysisTool;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.index.repository.sca.jfrog.JFrogXrayIndex;
import com.teamscale.index.repository.sca.jfrog.JFrogXraySynchronizer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.lib.commons.collections.CollectionUtils;

@ConnectorDescriptor
public class JFrogXrayConnectorDescriptor
extends ConnectorDescriptorBase {
    private static final String REPOSITORY_IDENTIFIER_PARAMETER_NAME = "SCA Connector identifier";
    private static final int DEFAULT_POLLING_INTERVAL_SECONDS = 1200;
    public static final String PROJECT_KEYS_PARAMETER = "JFrog Project Keys";
    public static final String BUILD_INCLUDE_PATTERNS = "Build Include Patterns";
    public static final String BUILD_EXCLUDE_PATTERNS = "Build Exclude Patterns";
    @ConfigExposed(name="Polling interval", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Delay used for polling the repository in seconds (default is 1200 seconds).", changeRequiresReAnalysis=false)
    public int pollingIntervalSeconds = 1200;
    @ConfigExposed(name="Build Include Patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Regex patterns describing the Xray build names to include. Patterns can be separated by comma or newline. Leave empty to include all builds.\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> buildIncludePatterns = new ArrayList<String>(Collections.singletonList(".*"));
    @ConfigExposed(name="Build Exclude Patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Regex patterns describing the Xray build names to be excluded. Patterns can be separated by comma or newline. Leave empty to exclude no builds.\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> buildExcludePatterns = new ArrayList<String>();
    private static final String DEFAULT_CONNECTOR_IDENTIFIER = "sca-tool1";
    @ConfigExposed(name="SCA Connector identifier", description="A unique identifier used to reference this SCA connector.", required=true)
    protected String connectorIdentifier = "sca-tool1";
    @ConfigExposed(name="Account", description="The account for this connector.", required=true)
    protected AccountCredentials accountIdentifier;
    @ConfigExposed(name="JFrog Project Keys", description="The project keys of the JFrog projects to import. To include JFrog's default project, add \"artifactory\".", required=true)
    protected Set<String> xrayProjectKeys;

    public JFrogXrayConnectorDescriptor() {
        super((IConnectorEnum)ESoftwareCompositionAnalysisTool.JFROG_XRAY, EConnectorType.SOFTWARE_COMPOSITION_ANALYSIS_TOOL);
        this.autoExpose();
    }

    protected void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) {
    }

    public void deleteConfigurationData(ProjectStorageSystem projectStorageSystem, String uri) {
    }

    public String getConnectorIdentifier() {
        return this.connectorIdentifier;
    }

    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        this.checkNonNegative(this.pollingIntervalSeconds, "Polling interval");
        if (this.buildIncludePatterns.isEmpty()) {
            this.buildIncludePatterns.add(".*");
        }
        triggerCreator.createTrigger(new TriggerBuilder(JFrogXraySynchronizer.class).setTriggerParameter("connector-id", this.connectorIdentifier).setTriggerParameter("polling-interval-seconds", this.pollingIntervalSeconds).setTriggerParameter(BUILD_INCLUDE_PATTERNS, ITriggerParameter.of(this.buildIncludePatterns)).setTriggerParameter(BUILD_EXCLUDE_PATTERNS, ITriggerParameter.of(this.buildExcludePatterns)).setTriggerParameter(PROJECT_KEYS_PARAMETER, ITriggerParameter.of((Object)CollectionUtils.emptyIfNull(this.xrayProjectKeys))).setTriggerParameter("account-identifier", Optional.ofNullable(this.accountIdentifier).map(AccountCredentials::getAccountIdentifier).orElse("account identifier unavailable")).setSchedulingParameter(ESchedulingParameter.PERIOD, (Object)Duration.ofSeconds(this.pollingIntervalSeconds)), this.getConnectorIdentifier());
    }

    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(JFrogXrayIndex.class);
    }

    public String getConnectorIdentifierOptionName() {
        return REPOSITORY_IDENTIFIER_PARAMETER_NAME;
    }
}

