/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.polarion.alm.ws.client.types.planning.Plan;
import com.polarion.alm.ws.client.types.tracker.Module;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.concurrent.FutureWithException;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;

public class PolarionExternalElementCache {
    private static final int MAXIMUM_CACHE_SIZE = 10000;
    private final LoadingCache<String, Module> moduleCache = PolarionExternalElementCache.buildCache(client::getModuleByUri);
    private final LoadingCache<String, Optional<Plan>> planCache = PolarionExternalElementCache.buildCache(client::getPlanByUri);

    public PolarionExternalElementCache(PolarionServiceClient client) {
    }

    private static <T> @NonNull LoadingCache<String, T> buildCache(final Function<String, FutureWithException<T, PolarionServerException>> loader) {
        return CacheBuilder.newBuilder().maximumSize(10000L).concurrencyLevel(1).build(new CacheLoader<String, T>(){

            public @NonNull T load(@NonNull String moduleUri) throws PolarionServerException, InterruptedException {
                return ((FutureWithException)loader.apply(moduleUri)).getWithException();
            }
        });
    }

    public Module getModuleByUri(String moduleUri) throws PolarionServerException, InterruptedException {
        try {
            return (Module)this.moduleCache.get((Object)moduleUri);
        }
        catch (ExecutionException e) {
            return (Module)PolarionExternalElementCache.handleException(e, () -> "Unexpected Exception while fetching module for URI: %s".formatted(moduleUri));
        }
    }

    public Optional<Plan> getPlanByUri(String planUri) throws PolarionServerException, InterruptedException {
        try {
            return (Optional)this.planCache.get((Object)planUri);
        }
        catch (ExecutionException e) {
            return (Optional)PolarionExternalElementCache.handleException(e, () -> "Unexpected Exception while fetching plan for URI: %s".formatted(planUri));
        }
    }

    @Contract(value="_, _ -> fail")
    private static <T> T handleException(ExecutionException e, Supplier<String> failMessage) throws PolarionServerException, InterruptedException {
        Throwable cause = e.getCause();
        if (cause instanceof PolarionServerException) {
            PolarionServerException serverException = (PolarionServerException)cause;
            throw serverException;
        }
        if (cause instanceof InterruptedException) {
            InterruptedException interruptedException = (InterruptedException)cause;
            throw interruptedException;
        }
        if (cause instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)cause;
            throw runtimeException;
        }
        return (T)CCSMAssert.fail((String)failMessage.get(), (Throwable)cause);
    }
}

