/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.architecture;

import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

@Index(name="metric-to-arch-mapping", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class MetricsToArchitectureMetricsMappingIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "metric-to-arch-mapping";
    public static final String SEPARATOR = "<-sep->";
    public static final String NO_MAPPINGS = "--NO_MAPPING--";
    private final KeysOnlyIndex delegate;

    public MetricsToArchitectureMetricsMappingIndex(IStore store) {
        this.delegate = new KeysOnlyIndex(store);
    }

    private static String createMapping(String path1, String path2) {
        return path1 + SEPARATOR + path2;
    }

    public static String[] splitMapping(String mapping) {
        return mapping.split(SEPARATOR, 2);
    }

    public void setMappedPaths(List<String> mappings) throws StorageException {
        this.delegate.storeKeys(mappings);
    }

    public void removeMappings(List<String> mappings) throws StorageException {
        this.delegate.removeKeys(mappings);
    }

    public List<String> getMappingsStartingWith(@NonNull String prefix) throws StorageException {
        return this.delegate.streamKeysStartingWith(prefix).collect(Collectors.toList());
    }

    public List<String> getMappingsStartingWith(List<String> prefixes) throws StorageException {
        ArrayList<String> mappings = new ArrayList<String>();
        for (String prefix : prefixes) {
            mappings.addAll(this.getMappingsStartingWith(prefix));
        }
        return mappings;
    }

    public void removeArchitectureMetricData(List<String> architecturePaths) throws StorageException {
        for (String path : architecturePaths) {
            this.removeMappings(this.getAllMappingsForArchitecture(path));
        }
    }

    public static List<String> createMappings(String currentComponentPath, Collection<String> matchedFiles) {
        ArrayList<String> mappedPaths = new ArrayList<String>();
        for (String matchedFile : matchedFiles) {
            String combinedPath = ArchitectureMetricsUtils.getCombinedPath(currentComponentPath, matchedFile);
            mappedPaths.add(MetricsToArchitectureMetricsMappingIndex.createMapping(matchedFile, combinedPath));
            mappedPaths.add(MetricsToArchitectureMetricsMappingIndex.createMapping(combinedPath, matchedFile));
        }
        return mappedPaths;
    }

    private static String invertKey(String key) {
        String[] parts = MetricsToArchitectureMetricsMappingIndex.splitMapping(key);
        return MetricsToArchitectureMetricsMappingIndex.createMapping(parts[1], parts[0]);
    }

    public List<String> getAllMappingsForArchitecture(String architecture) throws StorageException {
        String architecturePath = ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES + "/" + architecture;
        List<String> keys = this.getMappingsStartingWith(architecturePath);
        keys.addAll(CollectionUtils.map(keys, MetricsToArchitectureMetricsMappingIndex::invertKey));
        return keys;
    }
}

