/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.IMetricSchemaRetriever;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.user.User;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.ResourceResolutionStrategyFactory;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyBase;
import com.teamscale.index.resource.utils.EResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.QueryEngine;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class StoredQueryMetricRetrievalStrategyBase
extends MetricRetrievalStrategyBase
implements IMetricRetrievalStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final StoredQueryIndex.EStoredQueryType storedQueryType;

    protected StoredQueryMetricRetrievalStrategyBase(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, StoredQueryIndex.EStoredQueryType storedQueryType) {
        super(projectStorageSystem, globalStorageSystem, currentUser, (IMetricSchemaRetriever)new IMetricSchemaRetriever.EmptySchemaRetriever());
        this.storedQueryType = storedQueryType;
    }

    @Override
    public MetricDirectorySchemaEntry getMetricDirectorySchemaEntry(String metricName) throws StorageException {
        return this.getMetricDirectorySchema(null).getAllEntries().stream().filter(entry -> entry.getName().equals(metricName)).findFirst().orElse(null);
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        StoredQueryMetricRetrievalStrategyBase.ensureNotNullOrEmpty(uniformPathPrefixes);
        ArrayList<MetricDirectoryEntry> entries = new ArrayList<MetricDirectoryEntry>();
        for (String uniformPathPrefix : uniformPathPrefixes) {
            UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)uniformPathPrefix);
            IResourceResolutionStrategy resourceResolutionStrategy = ResourceResolutionStrategyFactory.getStrategy(uniformPath, this.projectStorageSystem);
            Set<UniformPath> issuePaths = StoredQueryMetricRetrievalStrategyBase.getIssueQueryPaths(uniformPath, resourceResolutionStrategy);
            issuePaths.add(uniformPath);
            for (UniformPath issuePath : issuePaths) {
                entries.addAll(this.getMetricDirectoryEntries(issuePath, historyAccessOption));
            }
        }
        return entries;
    }

    protected List<MetricDirectoryEntry> getMetricDirectoryEntries(UniformPath queryPath, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectoryEntry entry = this.getMetricDirectoryEntry(queryPath, historyAccessOption);
        if (entry == null) {
            return Collections.emptyList();
        }
        return List.of(entry);
    }

    @VisibleForTesting
    static Set<UniformPath> getIssueQueryPaths(UniformPath uniformPath, IResourceResolutionStrategy resourceResolutionStrategy) throws StorageException {
        HashSet<UniformPath> result = new HashSet<UniformPath>();
        HashSet<UniformPath> containersToProcess = new HashSet<UniformPath>();
        containersToProcess.add(uniformPath);
        while (!containersToProcess.isEmpty()) {
            UniformPath element = (UniformPath)CollectionUtils.getAny(containersToProcess);
            Map<String, EResourceType> resourceTypes = resourceResolutionStrategy.getResourceChildTypesForPath(element, true, null);
            for (Map.Entry<String, EResourceType> resourceTypeEntry : resourceTypes.entrySet()) {
                UniformPath resourcePath = UniformPathCompatibilityUtil.convert((String)resourceTypeEntry.getKey());
                if (resourceTypeEntry.getValue() == EResourceType.CONTAINER) {
                    containersToProcess.add(resourcePath);
                    continue;
                }
                result.add(resourcePath);
            }
            containersToProcess.remove(element);
        }
        return result;
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema(HistoryAccessOption historyAccess) throws StorageException {
        return this.createMetricSchema();
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema() throws StorageException {
        return this.createMetricSchema();
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        StoredQueryDescriptor queryDescriptor = StoredQueryMetricRetrievalStrategyBase.getQueryDescriptorForPath(uniformPath, this.getStoredQueryIndex());
        return StoredQueryMetricRetrievalStrategyBase.convertIssueTrend(QueryableEntityUtils.getIssueTrend(this.getHistoryIndex(end), queryDescriptor.getQuery(), new QueryableEntityUtils.QueryContext(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, this.getStoredQueryIndex(), start.getTimestamp(), end.getTimestamp(), end.getBranchName(), false)));
    }

    protected static StoredQueryDescriptor getQueryDescriptorForPath(UniformPath uniformPath, StoredQueryIndex metricIndex) throws StorageException {
        if (uniformPath.isRoot()) {
            return new StoredQueryDescriptor("", "");
        }
        String queryPath = uniformPath.getSubPath(0).toString();
        return metricIndex.getQuery(queryPath).orElseThrow(() -> new IllegalArgumentException("Unknown metric: " + String.valueOf(uniformPath)));
    }

    private static List<TrendIndexBase.TrendEntry<Object[]>> convertIssueTrend(PairList<Long, Double> trend) {
        ArrayList<TrendIndexBase.TrendEntry<Object[]>> result = new ArrayList<TrendIndexBase.TrendEntry<Object[]>>();
        for (int i = 0; i < trend.size(); ++i) {
            TrendIndexBase.TrendEntry trendEntry = new TrendIndexBase.TrendEntry(((Long)trend.getFirst(i)).longValue(), (Object)new Object[]{trend.getSecond(i)});
            result.add((TrendIndexBase.TrendEntry<Object[]>)trendEntry);
        }
        return result;
    }

    protected static MetricDirectoryEntry getMetricDirectoryEntry(List<String> issueIds, UniformPath uniformPath, int metricDirectoryEntryTotalSize) {
        MetricDirectoryEntry entry = new MetricDirectoryEntry(uniformPath.toString(), metricDirectoryEntryTotalSize);
        entry.setValue(0, (Object)issueIds.size());
        return entry;
    }

    protected List<String> getIssueIds(UniformPath uniformPath, IKeyedObjectIndex<?> historyIndex, HistoryAccessOption historyAccessOption) throws StorageException {
        try {
            if (uniformPath.isRoot()) {
                return new ArrayList<String>(historyIndex.getAllIds());
            }
            QueryableEntityUtils.QueryContext queryContext = QueryableEntityUtils.QueryContext.ofTimestamp(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, this.storedQueryType, historyAccessOption);
            StoredQueryDescriptor storedQueryDescriptor = StoredQueryMetricRetrievalStrategyBase.getQueryDescriptorForPath(uniformPath, queryContext.queryIndex());
            String query = storedQueryDescriptor.getQuery();
            return QueryEngine.selectIds(historyIndex, (String)query, (QueryEngine.IQueryContext)queryContext);
        }
        catch (IllegalArgumentException | QueryCompilationException | QueryParsingException e) {
            LOGGER.warn("Metric query evaluation failed: " + String.valueOf(e));
            return null;
        }
    }

    protected MetricDirectorySchema createMetricSchema() throws StorageException {
        MetricDirectorySchemaEntry entry = new MetricDirectorySchemaEntry(this.getBasicMetricName(), "Number of issues matching the criteria", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.SIZE_METRIC, EMetricProperty.QUALITY_NEUTRAL));
        return new MetricDirectorySchema(List.of(entry));
    }

    protected abstract String getBasicMetricName();

    protected final StoredQueryIndex getStoredQueryIndex() throws StorageException {
        return StoredQueryIndex.openIndex(this.projectStorageSystem, this.storedQueryType);
    }

    protected abstract IKeyedObjectIndex<?> getHistoryIndex(CommitDescriptor var1) throws StorageException;
}

