/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.resource.SimulinkModelInfo;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.simulink.content.SimulinkFileSynchronizer;
import com.teamscale.index.simulink.tracing.DerivedTestCoverageIndex;
import com.teamscale.index.simulink.tracing.DerivedTestCoverageInfo;
import com.teamscale.index.simulink.tracing.PlcCoderSimulinkCodeGenerationSourceFileMapper;
import com.teamscale.index.simulink.tracing.SimulinkCoderGeneratorTracingUtils;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import com.teamscale.index.simulink.tracing.SimulinkSourceFileMapper;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import com.teamscale.index.testcoverage.CoverageAdjuster;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SimulinkGeneratedCodeCoverageSynchronizer
extends ChangeProcessorAnalysisStep {
    public static final String MODEL_COVERED_LINES_PARTITION = "model-covered-lines";
    public static final String MODEL_COVERABLE_LINES_PARTITION = "model-coverable-lines";
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="content")
    private TokenElementIndex previousContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private LineCoverageIndex lineCoverageIndex;
    @DeltaSource(value=LineCoverageIndex.class)
    private KeyDelta lineCoverageDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkModelInfoIndex modelInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TracelinkAbbreviationIndex tracelinkAbbreviationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private DerivedTestCoverageIndex derivedTestCoverageIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkPlcCoderTraceIndex plcCoderTraceIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private SimulinkPlcCoderTraceIndex previousPlcCoderTraceIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics")
    private MetricsIndex metricsIndex;

    public void execute() throws StorageException {
        this.handleDeletedModels();
        HashMap<String, TokenElementInfo> loadedSourceElements = new HashMap<String, TokenElementInfo>();
        HashMap<String, TokenElementLineInfo> loadedSourceLineInfoElements = new HashMap<String, TokenElementLineInfo>();
        HashSet<String> deletedSourceFilePaths = new HashSet<String>();
        Set<String> affectedModelPaths = this.loadRequiredElementsAndDetermineAffectedModelPaths(loadedSourceElements, loadedSourceLineInfoElements, deletedSourceFilePaths);
        if (affectedModelPaths.isEmpty()) {
            return;
        }
        Map<String, DerivedTestCoverageInfo> modelPathToCoverageInfo = this.loadDerivedCoverageInfo(affectedModelPaths);
        if (!deletedSourceFilePaths.isEmpty()) {
            modelPathToCoverageInfo.values().forEach(info -> info.removeSourceFiles(deletedSourceFilePaths));
        }
        List<String> changedModelFiles = SimulinkFileSynchronizer.filterSimulinkModels(this.contentDelta.getAddedOrChangedKeysAsStrings());
        changedModelFiles.retainAll(affectedModelPaths);
        if (!changedModelFiles.isEmpty()) {
            List<SimulinkModelInfo> modelInfos = this.modelInfoIndex.getModelInfos(changedModelFiles);
            for (int i = 0; i < changedModelFiles.size(); ++i) {
                modelPathToCoverageInfo.get(changedModelFiles.get(i)).adjustToModel(modelInfos.get(i));
            }
        }
        this.updateCoverageRegions(loadedSourceElements, loadedSourceLineInfoElements, modelPathToCoverageInfo);
        Map<String, LineCoverageInfo> sourcePathToCoverageInfo = this.loadReferencedLineCoverage(modelPathToCoverageInfo.values());
        for (DerivedTestCoverageInfo info2 : modelPathToCoverageInfo.values()) {
            info2.recalculateCoverage(sourcePathToCoverageInfo);
        }
        this.persistResults(modelPathToCoverageInfo);
    }

    private Map<String, LineCoverageInfo> loadReferencedLineCoverage(Collection<DerivedTestCoverageInfo> coverageInfos) throws StorageException {
        HashMap<String, LineCoverageInfo> sourcePathToCoverageInfo = new HashMap<String, LineCoverageInfo>();
        List<String> sourcePaths = coverageInfos.stream().flatMap(DerivedTestCoverageInfo::getSourceUniformPathAsStream).distinct().collect(Collectors.toList());
        ArrayList<Boolean> coverageInfoPresent = new ArrayList<Boolean>();
        ArrayList<LineCoverageInfo> coverage = new ArrayList<LineCoverageInfo>();
        for (int i = 0; i < sourcePaths.size(); ++i) {
            coverage.add(new LineCoverageInfo(false));
            coverageInfoPresent.add(false);
        }
        Map infosByPartition = this.lineCoverageIndex.getCoverageInfos(this.lineCoverageIndex.getPartitions(), sourcePaths);
        for (String partition : infosByPartition.keySet()) {
            Map partitionInfos = infosByPartition.get(partition);
            for (int i = 0; i < coverage.size(); ++i) {
                LineCoverageInfo partitionInfo = (LineCoverageInfo)partitionInfos.get(sourcePaths.get(i));
                if (partitionInfo == null) continue;
                ((LineCoverageInfo)coverage.get(i)).addAll(partitionInfo);
                coverageInfoPresent.set(i, true);
            }
        }
        List<TokenElementLineInfo> elementLineInfos = this.tokenElementLineInfoIndex.getLineInfos(sourcePaths, true);
        for (int i = 0; i < sourcePaths.size(); ++i) {
            String uniformPath = sourcePaths.get(i);
            TokenElementLineInfo elementLineInfo = elementLineInfos.get(i);
            CoverageAdjuster.correctLineCoverage(uniformPath, elementLineInfo, (LineCoverageInfo)coverage.get(i), (Boolean)coverageInfoPresent.get(i));
            sourcePathToCoverageInfo.put(sourcePaths.get(i), (LineCoverageInfo)coverage.get(i));
        }
        return sourcePathToCoverageInfo;
    }

    private void updateCoverageRegions(Map<String, TokenElementInfo> loadedSourceElements, Map<String, TokenElementLineInfo> loadedSourceLineInfoElements, Map<String, DerivedTestCoverageInfo> modelPathToCoverageInfo) throws StorageException {
        List changedSourcePaths = this.contentDelta.getAddedOrChangedKeysAsStrings();
        for (String changedSourcePath : changedSourcePaths) {
            TokenElementInfo sourceContent = loadedSourceElements.get(changedSourcePath);
            if (sourceContent == null) continue;
            TokenElementLineInfo sourceLineInfo = loadedSourceLineInfoElements.get(changedSourcePath);
            List<String> referencedModels = this.determineModelsReferencedBySourceFile(sourceContent, this.plcCoderTraceIndex);
            for (String modelPath : referencedModels) {
                this.insertCoverageRegions(sourceContent, modelPathToCoverageInfo.get(modelPath), sourceLineInfo, new ElementLocation(modelPath));
            }
        }
    }

    private void insertCoverageRegions(TokenElementInfo sourceContent, DerivedTestCoverageInfo derivedTestCoverageInfo, TokenElementLineInfo tokenElementLineInfo, ElementLocation defaultSimulinkLocation) throws StorageException {
        LineCoverageInfo coverage = new LineCoverageInfo(false);
        CoverageAdjuster.correctLineCoverage(sourceContent.getUniformPath(), tokenElementLineInfo, coverage, false);
        SimulinkSourceFileMapper mapper = new SimulinkSourceFileMapper(sourceContent, this.modelInfoIndex, this.tracelinkAbbreviationIndex, this.plcCoderTraceIndex, defaultSimulinkLocation);
        Iterator iterator = coverage.getAllCoverableLines().iterator();
        while (iterator.hasNext()) {
            int line = (Integer)iterator.next();
            for (ElementLocation location : mapper.resolveSimulinkLocationsForLine(line)) {
                String id = location instanceof QualifiedNameLocation ? ((QualifiedNameLocation)location).getQualifiedName() : (sourceContent.getLanguage() == ELanguage.IEC61131 ? "$bdroot" : SimulinkCoderGeneratorTracingUtils.extractModelName(sourceContent).orElse("$bdroot"));
                TextRegionLocation codeLocation = new TextRegionLocation(sourceContent.getUniformPath(), -1, -1, line, line);
                derivedTestCoverageInfo.insertSourceLocation(id, codeLocation);
            }
        }
    }

    private void handleDeletedModels() throws StorageException {
        List<String> deletedModels = SimulinkFileSynchronizer.filterSimulinkModels(this.contentDelta.getDeletedKeysAsStrings());
        if (!deletedModels.isEmpty()) {
            this.derivedTestCoverageIndex.removeModels(deletedModels);
            this.metricsIndex.removeEntries(deletedModels, Arrays.asList(MODEL_COVERABLE_LINES_PARTITION, MODEL_COVERED_LINES_PARTITION));
        }
    }

    private Set<String> loadRequiredElementsAndDetermineAffectedModelPaths(Map<String, TokenElementInfo> loadedSourceElements, Map<String, TokenElementLineInfo> loadedSourceLineInfoElements, Set<String> deletedSourceFilePaths) throws StorageException {
        List deletedCodeUniformPaths;
        HashSet<String> affectedModelPaths = new HashSet<String>();
        affectedModelPaths.addAll(SimulinkFileSynchronizer.filterSimulinkModels(this.contentDelta.getAddedOrChangedKeysAsStrings()));
        ArrayList<String> addedOrChangedPaths = new ArrayList<String>(CollectionUtils.unionSet((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), (Collection[])new Collection[]{PartitionIndexBase.splitKeys((Collection)this.lineCoverageDelta.getAddedOrChangedKeysAsStrings()).getValues()}));
        if (!addedOrChangedPaths.isEmpty()) {
            Map elements = CollectionUtils.zipAsMap(addedOrChangedPaths, this.contentIndex.getTokenElements(addedOrChangedPaths, false));
            elements.entrySet().removeIf(entry -> entry.getValue() == null || !SimulinkSourceFileMapper.fileMayBeGeneratedFromSimulinkModel((TokenElementInfo)((Object)((Object)entry.getValue()))));
            ArrayList<String> relevantSourcePaths = new ArrayList<String>(elements.keySet());
            List<TokenElementLineInfo> lineInfoElements = this.tokenElementLineInfoIndex.getLineInfos(relevantSourcePaths, true);
            for (int i = 0; i < relevantSourcePaths.size(); ++i) {
                String uniformPath = (String)relevantSourcePaths.get(i);
                TokenElementInfo element = (TokenElementInfo)((Object)elements.get(uniformPath));
                affectedModelPaths.addAll(this.determineModelsReferencedBySourceFile(element, this.plcCoderTraceIndex));
                loadedSourceElements.put(uniformPath, element);
                loadedSourceLineInfoElements.put(uniformPath, lineInfoElements.get(i));
            }
        }
        if (!(deletedCodeUniformPaths = this.contentDelta.getDeletedKeysAsStrings()).isEmpty()) {
            List<TokenElementInfo> oldContents = this.previousContentIndex.getTokenElements(deletedCodeUniformPaths);
            for (int i = 0; i < deletedCodeUniformPaths.size(); ++i) {
                TokenElementInfo oldContent = oldContents.get(i);
                if (oldContent == null || !SimulinkSourceFileMapper.fileMayBeGeneratedFromSimulinkModel(oldContent)) continue;
                deletedSourceFilePaths.add((String)deletedCodeUniformPaths.get(i));
                affectedModelPaths.addAll(this.determineModelsReferencedBySourceFile(oldContent, this.previousPlcCoderTraceIndex));
                this.extractModelPathForSimulinkCoderGeneratedSourceFile(oldContent).ifPresent(affectedModelPaths::add);
            }
        }
        return affectedModelPaths;
    }

    private List<String> determineModelsReferencedBySourceFile(TokenElementInfo element, SimulinkPlcCoderTraceIndex plcCoderTraceIndex) throws StorageException {
        if (element.getLanguage() == ELanguage.IEC61131) {
            List<String> targetModelPaths = PlcCoderSimulinkCodeGenerationSourceFileMapper.generateTracingBeaconsForPlcCoder(element, plcCoderTraceIndex).stream().flatMap(beacon -> beacon.getTargetLocations().stream()).map(ElementLocation::getUniformPath).distinct().toList();
            return targetModelPaths;
        }
        Optional<String> modelPath = this.extractModelPathForSimulinkCoderGeneratedSourceFile(element);
        if (modelPath.isPresent()) {
            return Collections.singletonList(modelPath.get());
        }
        return Collections.emptyList();
    }

    private Map<String, DerivedTestCoverageInfo> loadDerivedCoverageInfo(Set<String> affectedModelPaths) throws StorageException {
        HashMap<String, DerivedTestCoverageInfo> modelPathToCoverageInfo = new HashMap<String, DerivedTestCoverageInfo>();
        ArrayList<String> affectedModelPathsList = new ArrayList<String>(affectedModelPaths);
        List<DerivedTestCoverageInfo> infos = this.derivedTestCoverageIndex.getCoverageInfo(affectedModelPathsList);
        for (int i = 0; i < affectedModelPathsList.size(); ++i) {
            DerivedTestCoverageInfo info = infos.get(i);
            if (info == null) {
                info = new DerivedTestCoverageInfo();
            }
            modelPathToCoverageInfo.put((String)affectedModelPathsList.get(i), info);
        }
        return modelPathToCoverageInfo;
    }

    private void persistResults(Map<String, DerivedTestCoverageInfo> modelPathToCoverageInfo) throws StorageException {
        PairList coverableLinesValues = new PairList();
        PairList coveredLinesValues = new PairList();
        for (Map.Entry<String, DerivedTestCoverageInfo> entry : modelPathToCoverageInfo.entrySet()) {
            entry.getValue().sort();
            coverableLinesValues.add((Object)entry.getKey(), (Object)entry.getValue().getFirstInfoCoverableLines());
            coveredLinesValues.add((Object)entry.getKey(), (Object)entry.getValue().getFirstInfoCoveredLines());
        }
        this.derivedTestCoverageIndex.setCoverageInfo((PairList<String, DerivedTestCoverageInfo>)new PairList(modelPathToCoverageInfo));
        this.metricsIndex.setMetricValues(coverableLinesValues, MODEL_COVERABLE_LINES_PARTITION);
        this.metricsIndex.setMetricValues(coveredLinesValues, MODEL_COVERED_LINES_PARTITION);
    }

    private Optional<String> extractModelPathForSimulinkCoderGeneratedSourceFile(TokenElementInfo content) {
        Optional<String> modelName = SimulinkCoderGeneratorTracingUtils.extractModelName(content);
        if (!modelName.isPresent()) {
            return Optional.empty();
        }
        try {
            return this.modelInfoIndex.getUniqueUniformPathForModelName(modelName.get());
        }
        catch (StorageException e) {
            LOGGER.warn("Could not look up model path for " + modelName.get(), (Throwable)e);
            return Optional.empty();
        }
    }
}

