/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.engine.sourcecode.coverage.DecisionProbe;
import org.conqat.engine.sourcecode.coverage.McDcCondition;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.SimpleStatementCoverageProbe;
import org.conqat.engine.sourcecode.coverage.volume.ConditionalStatementSubtypes;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionParserFactory;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.SubConditionParserBase;

public class McDcCoverableAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Optional<ProbeCoverageInfo> analyze(TokenElementInfo tokenElement) {
        ELanguage language = tokenElement.getLanguage();
        if (!ConditionParserFactory.supportsLanguage((ELanguage)language)) {
            return Optional.empty();
        }
        IConditionExtractor conditionExtractor = ConditionParserFactory.createConditionExtractor((ELanguage)language);
        SubConditionParserBase subConditionParser = ConditionParserFactory.createSubConditionParser((ELanguage)language);
        List entities = ShallowEntityTraversalUtils.listAllEntities(tokenElement.getShallowEntitiesWithoutPreprocessorTokens());
        ArrayList<CoverageProbeBase> probes = new ArrayList<CoverageProbeBase>();
        for (ShallowEntity entity : entities) {
            switch (entity.getType()) {
                case STATEMENT: {
                    try {
                        McDcCoverableAnalyzer.processStatement(entity, conditionExtractor, subConditionParser, probes);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Failed to determine probes in " + tokenElement.getUniformPath() + " at lines " + String.valueOf(entity.getLineBasedRegion()) + "! Will skip creating a probe for this statement.", (Throwable)e);
                    }
                    break;
                }
                case METHOD: {
                    probes.add((CoverageProbeBase)new SimpleStatementCoverageProbe(entity.getStartLine(), 0));
                    break;
                }
            }
        }
        return Optional.of(new ProbeCoverageInfo(false, probes));
    }

    private static void processStatement(ShallowEntity statement, IConditionExtractor conditionExtractor, SubConditionParserBase subConditionParser, List<CoverageProbeBase> probes) {
        if (statement.getSubtype().equals("simple statement") && "return".equals(statement.getName())) {
            probes.add((CoverageProbeBase)new SimpleStatementCoverageProbe(statement.getStartLine(), 0));
        } else if (ConditionalStatementSubtypes.isConditionalStatement((ShallowEntity)statement)) {
            Condition condition = conditionExtractor.extractCondition(statement);
            if (condition == null) {
                return;
            }
            DecisionProbe decisionProbe = new DecisionProbe(statement.getStartLine(), 0, 0);
            List subConditions = subConditionParser.getSubConditions(condition);
            if (subConditions.size() > 1) {
                for (int i = 0; i < subConditions.size(); ++i) {
                    decisionProbe.addCondition(new McDcCondition(false, ""));
                }
            }
            probes.add((CoverageProbeBase)decisionProbe);
        }
    }
}

