/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.MethodInfoDelta;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.utils.TeamscaleIssueIdDeserializer;
import com.teamscale.index.utils.TeamscaleIssueIdSerializer;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="tga-method-issue", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={MethodLocation.class})
public class MethodIssueIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "tga-method-issue";
    public static final String NO_ISSUE_INTERNAL_ID = "###no-connector###|[no-issue]";
    public static final TeamscaleIssueId NO_ISSUE = TeamscaleIssueId.fromInternalId((String)"###no-connector###|[no-issue]");
    private static final byte[] PATH_PREFIX = new byte[]{0};
    private static final byte[] ISSUE_PREFIX = new byte[]{1};

    public MethodIssueIndex(IStore store) {
        super(store);
    }

    public void updateMappings(List<MethodLocation> deletedMethods, Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> changedMethodToTimestampMapping) throws StorageException {
        this.updateIssueBasedMappings(deletedMethods, changedMethodToTimestampMapping);
        this.updatePathBasedMappings(deletedMethods, changedMethodToTimestampMapping);
    }

    private void updateIssueBasedMappings(List<MethodLocation> deletedMethods, Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> changedMethodToTimestampMapping) throws StorageException {
        List<TeamscaleIssueId> affectedIssueIds = this.calculateAffectedIssueIds(deletedMethods, changedMethodToTimestampMapping);
        List<Map<MethodLocation, Long>> mappings = this.getMappingsForIssueIds(affectedIssueIds);
        PairList dataToWrite = new PairList();
        for (int i = 0; i < affectedIssueIds.size(); ++i) {
            TeamscaleIssueId issueId = affectedIssueIds.get(i);
            TreeMap<MethodLocation, Long> methodLocationToLastChangeTimestampMapping = new TreeMap<MethodLocation, Long>(mappings.get(i));
            for (MethodLocation deletedMethod : deletedMethods) {
                methodLocationToLastChangeTimestampMapping.remove(deletedMethod);
            }
            changedMethodToTimestampMapping.forEach((changedMethod, changedMethodMapping) -> {
                if (changedMethodMapping.containsKey(issueId)) {
                    methodLocationToLastChangeTimestampMapping.put(changedMethod.getNewMethod(), (Long)changedMethodMapping.get(issueId));
                } else if (changedMethod.isFirstParentAddition()) {
                    methodLocationToLastChangeTimestampMapping.remove(changedMethod.getNewMethod());
                }
            });
            dataToWrite.add((Object)MethodIssueIndex.makeIssueKey(issueId), (Object)this.serializeMethodToLastChangeTimestampMapping(methodLocationToLastChangeTimestampMapping));
        }
        this.store.put(dataToWrite);
    }

    private byte[] serializeMethodToLastChangeTimestampMapping(TreeMap<MethodLocation, Long> methodLocationToLastChangeTimestampMapping) throws StorageException {
        MethodLocation.MethodLocationSerializer methodLocationSerializer = new MethodLocation.MethodLocationSerializer(this.store.getAbbreviator(), new ArrayList<MethodLocation>(methodLocationToLastChangeTimestampMapping.keySet()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (Map.Entry<MethodLocation, Long> entry : methodLocationToLastChangeTimestampMapping.entrySet()) {
            outputStream.writeBytes(methodLocationSerializer.serialize(entry.getKey()));
            outputStream.writeBytes(ByteArrayUtils.longToByteArray((long)entry.getValue()));
        }
        return outputStream.toByteArray();
    }

    private List<TeamscaleIssueId> calculateAffectedIssueIds(List<MethodLocation> deletedMethods, Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> changedMethodToTimestampMapping) throws StorageException {
        HashSet<TeamscaleIssueId> affectedIssueIds = new HashSet<TeamscaleIssueId>(this.getIssuesFromPathBasedMappings(deletedMethods));
        changedMethodToTimestampMapping.values().stream().map(Map::keySet).forEach(affectedIssueIds::addAll);
        return new ArrayList<TeamscaleIssueId>(affectedIssueIds);
    }

    private void updatePathBasedMappings(List<MethodLocation> deletedMethods, Map<MethodInfoDelta.ChangedMethod, Map<TeamscaleIssueId, Long>> addedOrChangedMethodToTimestampMapping) throws StorageException {
        MethodLocation.MethodLocationSerializer deletedMethodLocationSerializer = new MethodLocation.MethodLocationSerializer(this.store.getAbbreviator(), deletedMethods);
        this.store.remove(CollectionUtils.map(deletedMethods, method -> MethodIssueIndex.makePathKey(deletedMethodLocationSerializer.serialize(method))));
        MethodLocation.MethodLocationSerializer methodLocationSerializer = new MethodLocation.MethodLocationSerializer(this.store.getAbbreviator(), CollectionUtils.map(addedOrChangedMethodToTimestampMapping.keySet(), MethodInfoDelta.ChangedMethod::getNewMethod));
        PairList dataToWrite = new PairList();
        for (MethodInfoDelta.ChangedMethod addedOrChangedMethod : addedOrChangedMethodToTimestampMapping.keySet()) {
            Map<TeamscaleIssueId, Long> mapping = addedOrChangedMethodToTimestampMapping.get(addedOrChangedMethod);
            byte[] pathKey = MethodIssueIndex.makePathKey(methodLocationSerializer.serialize(addedOrChangedMethod.getNewMethod()));
            dataToWrite.add((Object)pathKey, (Object)this.serializeIssueUpdateMapping(new HashMap<TeamscaleIssueId, Long>(mapping)));
        }
        this.store.put(dataToWrite);
    }

    private byte[] serializeIssueUpdateMapping(HashMap<TeamscaleIssueId, Long> teamscaleIssueIdLongHashMap) throws StorageException {
        TeamscaleIssueIdSerializer issueIdSerializer = new TeamscaleIssueIdSerializer(this.store.getAbbreviator(), new ArrayList<TeamscaleIssueId>(teamscaleIssueIdLongHashMap.keySet()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (Map.Entry<TeamscaleIssueId, Long> entry : teamscaleIssueIdLongHashMap.entrySet()) {
            outputStream.writeBytes(issueIdSerializer.serialize(entry.getKey()));
            outputStream.writeBytes(ByteArrayUtils.longToByteArray((long)entry.getValue()));
        }
        return outputStream.toByteArray();
    }

    private static byte @NonNull [] makePathKey(byte @NonNull [] serializedMethodLocation) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{PATH_PREFIX, serializedMethodLocation});
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<MethodLocation, Map<TeamscaleIssueId, Long>> getMappingsForLocations(List<@Nullable MethodLocation> locations) throws StorageException {
        MethodLocation.MethodLocationSerializer methodLocationSerializer = new MethodLocation.MethodLocationSerializer(this.store.getAbbreviator(), locations);
        @NonNull List nonNullLocations = CollectionUtils.filterNullEntries(locations);
        List rawData = this.store.get(CollectionUtils.map((Collection)nonNullLocations, location -> MethodIssueIndex.makePathKey(methodLocationSerializer.serialize(location))));
        TeamscaleIssueIdDeserializer issueIdDeserializer = new TeamscaleIssueIdDeserializer(this.store.getAbbreviator());
        for (byte[] rawEntry : rawData) {
            MethodIssueIndex.collectAbbreviationIdsFromSerializedIssueIdToTimestampMap(rawEntry, issueIdDeserializer);
        }
        HashMap<MethodLocation, Map<TeamscaleIssueId, Long>> mappings = HashMap.newHashMap(rawData.size());
        for (int i = 0; i < rawData.size(); ++i) {
            HashMap<TeamscaleIssueId, Long> mapping = MethodIssueIndex.deserializeIssueIdToTimestampMap((byte[])rawData.get(i), issueIdDeserializer);
            if (mapping == null) continue;
            mappings.put((MethodLocation)nonNullLocations.get(i), mapping);
        }
        return mappings;
    }

    private static @Nullable HashMap<TeamscaleIssueId, Long> deserializeIssueIdToTimestampMap(byte @Nullable [] rawEntry, TeamscaleIssueIdDeserializer issueIdDeserializer) throws StorageException {
        if (rawEntry == null) {
            return null;
        }
        HashMap<TeamscaleIssueId, Long> deserializedMap = new HashMap<TeamscaleIssueId, Long>();
        for (int offset = 0; offset < rawEntry.length; offset += 8) {
            TeamscaleIssueId issueId = (TeamscaleIssueId)issueIdDeserializer.deserialize(rawEntry, offset);
            offset += TeamscaleIssueIdDeserializer.getEntryLength(rawEntry, offset);
            Long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])rawEntry, (int)offset);
            deserializedMap.put(issueId, timestamp);
        }
        return deserializedMap;
    }

    private static void collectAbbreviationIdsFromSerializedIssueIdToTimestampMap(byte @Nullable [] rawEntry, TeamscaleIssueIdDeserializer issueIdDeserializer) {
        if (rawEntry == null) {
            return;
        }
        for (int offset = 0; offset < rawEntry.length; offset += 8) {
            issueIdDeserializer.extractStringIdsToLoadIntoUnAbbreviationMap(rawEntry, offset);
            offset += TeamscaleIssueIdDeserializer.getEntryLength(rawEntry, offset);
        }
    }

    Map<TeamscaleIssueId, Long> getMappingForLocation(MethodLocation location) throws StorageException {
        MethodLocation.MethodLocationSerializer methodLocationSerializer = new MethodLocation.MethodLocationSerializer(this.store.getAbbreviator(), Collections.singletonList(location));
        byte[] rawData = this.store.get(MethodIssueIndex.makePathKey(methodLocationSerializer.serialize(location)));
        TeamscaleIssueIdDeserializer issueIdDeserializer = new TeamscaleIssueIdDeserializer(this.store.getAbbreviator());
        MethodIssueIndex.collectAbbreviationIdsFromSerializedIssueIdToTimestampMap(rawData, issueIdDeserializer);
        return MethodIssueIndex.deserializeIssueIdToTimestampMap(rawData, issueIdDeserializer);
    }

    public List<Map<MethodLocation, Long>> getMappingsForIssueIds(List<@NonNull TeamscaleIssueId> issueIds) throws StorageException {
        List rawData = this.store.get(CollectionUtils.map(issueIds, MethodIssueIndex::makeIssueKey));
        if (rawData == null) {
            return CollectionUtils.emptyList();
        }
        MethodLocation.MethodLocationDeserializer methodLocationDeserializer = new MethodLocation.MethodLocationDeserializer(this.store.getAbbreviator());
        for (byte[] rawEntry : rawData) {
            MethodIssueIndex.collectUniformPathIdsForMethodLocationToLastUpdatedTimestampMap(rawEntry, methodLocationDeserializer);
        }
        ArrayList<Map<MethodLocation, Long>> mappings = new ArrayList<Map<MethodLocation, Long>>();
        for (byte[] rawEntry : rawData) {
            mappings.add(MethodIssueIndex.deserializeMethodLocationToLastUpdatedTimestampMap(rawEntry, methodLocationDeserializer));
        }
        return mappings;
    }

    private static void collectUniformPathIdsForMethodLocationToLastUpdatedTimestampMap(byte[] rawEntry, MethodLocation.MethodLocationDeserializer methodLocationDeserializer) {
        if (rawEntry == null) {
            return;
        }
        for (int offset = 0; offset < rawEntry.length; offset += 20) {
            methodLocationDeserializer.extractStringIdsToLoadIntoUnAbbreviationMap(rawEntry, offset);
        }
    }

    private static Map<MethodLocation, Long> deserializeMethodLocationToLastUpdatedTimestampMap(byte[] rawEntry, MethodLocation.MethodLocationDeserializer methodLocationDeserializer) throws StorageException {
        HashMap<MethodLocation, Long> mapping = new HashMap<MethodLocation, Long>();
        if (rawEntry == null) {
            return mapping;
        }
        for (int offset = 0; offset < rawEntry.length; offset += 20) {
            MethodLocation location = (MethodLocation)methodLocationDeserializer.deserialize(rawEntry, offset);
            Long lastChangeTimestamp = ByteArrayUtils.getLongFromByteArray((byte[])rawEntry, (int)(offset + 12));
            mapping.put(location, lastChangeTimestamp);
        }
        return mapping;
    }

    public Set<TeamscaleIssueId> getIssuesFromPathBasedMappings(List<MethodLocation> methods) throws StorageException {
        return this.getMappingsForLocations(methods).values().stream().flatMap(mapping -> mapping.keySet().stream()).collect(Collectors.toSet());
    }

    public @Nullable Map<MethodLocation, Long> getMappingForIssueId(@NonNull TeamscaleIssueId issueId) throws StorageException {
        byte[] rawMapping = this.store.get(MethodIssueIndex.makeIssueKey(issueId));
        if (rawMapping == null) {
            return null;
        }
        MethodLocation.MethodLocationDeserializer methodLocationDeserializer = new MethodLocation.MethodLocationDeserializer(this.store.getAbbreviator());
        MethodIssueIndex.collectUniformPathIdsForMethodLocationToLastUpdatedTimestampMap(rawMapping, methodLocationDeserializer);
        return MethodIssueIndex.deserializeMethodLocationToLastUpdatedTimestampMap(rawMapping, methodLocationDeserializer);
    }

    private static byte @NonNull [] makeIssueKey(@NonNull TeamscaleIssueId issueId) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ISSUE_PREFIX, StringUtils.stringToBytes((String)issueId.getInternalId())});
    }
}

