/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

@Index(name="abap-includes", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class AbapIncludeIndex
implements IProjectIndex {
    private final ValueIndex<HashSet<String>> delegate;

    public AbapIncludeIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void removeIncludes(List<String> sourceUniformPaths) throws StorageException {
        List<? extends Set<String>> allInbounds = this.getInbounds(sourceUniformPaths);
        for (int i = 0; i < allInbounds.size(); ++i) {
            Set<String> inbounds = allInbounds.get(i);
            for (String removed : inbounds) {
                this.removeFromValueSet(AbapIncludeIndex.makeKey(IncludeDirectionRelation.OUTBOUND, removed), sourceUniformPaths.get(i));
            }
        }
        List<? extends Set<String>> allOutbounds = this.getOutbounds(sourceUniformPaths);
        for (int i = 0; i < allOutbounds.size(); ++i) {
            Set<String> outbounds = allOutbounds.get(i);
            for (String removed : outbounds) {
                this.removeFromValueSet(AbapIncludeIndex.makeKey(IncludeDirectionRelation.INBOUND, removed), sourceUniformPaths.get(i));
            }
        }
        this.delegate.removeValues(AbapIncludeIndex.makeKeys(IncludeDirectionRelation.INBOUND, sourceUniformPaths));
        this.delegate.removeValues(AbapIncludeIndex.makeKeys(IncludeDirectionRelation.OUTBOUND, sourceUniformPaths));
    }

    public void storeIncludes(String source, Set<String> targets) throws StorageException {
        Set<String> oldTargets = this.replace(AbapIncludeIndex.makeKey(IncludeDirectionRelation.OUTBOUND, source), targets);
        for (String removed : CollectionUtils.differenceSet(oldTargets, (Collection[])new Collection[]{targets})) {
            this.removeFromValueSet(AbapIncludeIndex.makeKey(IncludeDirectionRelation.INBOUND, removed), source);
        }
        for (String added : CollectionUtils.differenceSet(targets, (Collection[])new Collection[]{oldTargets})) {
            this.addToValueSet(AbapIncludeIndex.makeKey(IncludeDirectionRelation.INBOUND, added), source);
        }
    }

    public SetMap<String, String> getInboundsTransitive(List<String> uniformPaths) throws StorageException {
        return this.getTransitive(uniformPaths, IncludeDirectionRelation.INBOUND);
    }

    public SetMap<String, String> getOutboundsTransitive(List<String> uniformPaths) throws StorageException {
        return this.getTransitive(uniformPaths, IncludeDirectionRelation.OUTBOUND);
    }

    private SetMap<String, String> getTransitive(List<String> uniformPaths, IncludeDirectionRelation outboundOrInboundKey) throws StorageException {
        SetMap result = new SetMap();
        for (String uniformPath : uniformPaths) {
            Set<String> transitive = this.getTransitive(uniformPath, outboundOrInboundKey);
            result.addAll((Object)uniformPath, transitive);
        }
        return result;
    }

    private Set<String> getTransitive(String uniformPath, IncludeDirectionRelation direction) throws StorageException {
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> result = new HashSet<String>();
        Stack<String> workList = new Stack<String>();
        workList.push(uniformPath);
        while (!workList.isEmpty()) {
            String currentPath = (String)workList.pop();
            seen.add(currentPath);
            HashSet<String> includers = this.getIncludesOrEmptySet(AbapIncludeIndex.makeKey(direction, currentPath));
            result.addAll(includers);
            workList.addAll(CollectionUtils.differenceSet(includers, (Collection[])new Collection[]{seen}));
        }
        return result;
    }

    private static String makeKey(IncludeDirectionRelation direction, String currentPath) {
        return PartitionIndexBase.makeKey((String)direction.keyPrefix, (String)currentPath);
    }

    public List<? extends Set<String>> getOutbounds(List<String> files) throws StorageException {
        return this.getIncludesOrEmptySets(AbapIncludeIndex.makeKeys(IncludeDirectionRelation.OUTBOUND, files));
    }

    public List<? extends Set<String>> getInbounds(List<String> files) throws StorageException {
        return this.getIncludesOrEmptySets(AbapIncludeIndex.makeKeys(IncludeDirectionRelation.INBOUND, files));
    }

    private static List<String> makeKeys(IncludeDirectionRelation inboundOrOutbound, List<String> paths) {
        return CollectionUtils.map(paths, source -> AbapIncludeIndex.makeKey(inboundOrOutbound, source));
    }

    private void addToValueSet(String key, String value) throws StorageException {
        HashSet<String> set = this.getIncludesOrEmptySet(key);
        set.add(value);
        this.delegate.setValue(key, set);
    }

    private void removeFromValueSet(String key, String value) throws StorageException {
        HashSet values = (HashSet)this.delegate.getValue(key);
        if (values == null) {
            return;
        }
        values.remove(value);
        if (values.isEmpty()) {
            this.delegate.removeValue(key);
        } else {
            this.delegate.setValue(key, (Object)values);
        }
    }

    private Set<String> replace(String key, Set<String> values) throws StorageException {
        HashSet<String> oldValues = this.getIncludesOrEmptySet(key);
        if (values.isEmpty()) {
            this.delegate.removeValue(key);
        } else {
            this.delegate.setValue(key, new HashSet<String>(values));
        }
        return oldValues;
    }

    private HashSet<String> getIncludesOrEmptySet(String key) throws StorageException {
        return Optional.ofNullable((HashSet)this.delegate.getValue(key)).orElseGet(HashSet::new);
    }

    public List<HashSet<String>> getIncludesOrEmptySets(List<String> keys) throws StorageException {
        return this.delegate.getValues(keys).stream().map(value -> {
            if (value == null) {
                return new HashSet();
            }
            return value;
        }).toList();
    }

    public PairList<String, HashSet<String>> getAllIncludes() throws StorageException {
        return this.delegate.getAllEntries();
    }

    private static enum IncludeDirectionRelation {
        INBOUND("i"),
        OUTBOUND("o");

        private final String keyPrefix;

        private IncludeDirectionRelation(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }
    }
}

