/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.MethodIdMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MethodIdMappingUpdater {
    public static void initMethodIdMapper(MethodIdMapper methodIdMapper, CommitDescriptor commit, IndexDelta<UniformPath> childMethodInfoIndexDelta, MethodInfoIndex childMethodInfoIndex, List<MethodInfoIndex> parentMethodInfoIndices) throws StorageException {
        int numParents = parentMethodInfoIndices.size();
        ArrayList affectedUniformPathsFromMethodInfoDelta = CollectionUtils.unionList((Collection)childMethodInfoIndexDelta.getAddedOrChangedKeys(), (Collection[])new Collection[]{childMethodInfoIndexDelta.getDeletedKeys()});
        for (int i = 0; i < numParents; ++i) {
            methodIdMapper.preload(i, affectedUniformPathsFromMethodInfoDelta);
        }
        UnmodifiableList changedUniformPaths = childMethodInfoIndexDelta.getAddedOrChangedKeys();
        List<AssociatedMethodInfo> changedMethodInfos = childMethodInfoIndex.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo((List<UniformPath>)changedUniformPaths);
        for (AssociatedMethodInfo info : changedMethodInfos) {
            MethodLocation childMethodLocationKey = MethodIdMappingUpdater.registerMethodsWithPredecessors(methodIdMapper, numParents, info);
            if (info.getLastChangedTimestamp() != commit.getTimestamp()) continue;
            methodIdMapper.registerRealChange(childMethodLocationKey);
        }
        MethodIdMappingUpdater.registerDeletionsForNoLongerExistingMethodLocations(affectedUniformPathsFromMethodInfoDelta, methodIdMapper, parentMethodInfoIndices);
    }

    private static MethodLocation registerMethodsWithPredecessors(MethodIdMapper methodIdMapper, int numParents, AssociatedMethodInfo info) {
        List<String> parentMethodLocationKeys = info.extractPredecessorKeys();
        Preconditions.checkState((numParents == parentMethodLocationKeys.size() ? 1 : 0) != 0, (Object)"Method must have a predecessor entry for every parent commit!");
        MethodLocation childMethodLocationKey = info.getLocation();
        for (int i = 0; i < numParents; ++i) {
            String parentMethodKey = parentMethodLocationKeys.get(i);
            if (parentMethodKey == null) continue;
            methodIdMapper.registerChange(i, MethodLocation.fromIndexKey(parentMethodKey), childMethodLocationKey);
        }
        return childMethodLocationKey;
    }

    private static void registerDeletionsForNoLongerExistingMethodLocations(List<UniformPath> allUniformPathsFromMethodInfoDelta, MethodIdMapper methodIdMapper, List<MethodInfoIndex> parentMethodInfoIndices) throws StorageException {
        for (int i = 0; i < parentMethodInfoIndices.size(); ++i) {
            List<AssociatedMethodInfo> parentMethodInfos = parentMethodInfoIndices.get(i).getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(allUniformPathsFromMethodInfoDelta);
            for (AssociatedMethodInfo info : parentMethodInfos) {
                MethodLocation methodLocationKey = info.getLocation();
                if (methodIdMapper.hasKnownMapping(i, methodLocationKey)) continue;
                methodIdMapper.registerDeletedMethod(i, methodLocationKey);
            }
        }
    }
}

