/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.ClusteringMatchingStrategyBase;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import java.util.List;
import org.conqat.lib.commons.algo.MaxWeightMatching;
import org.conqat.lib.commons.collections.PairList;

public abstract class LocationBasedClusteringMatchingStrategyBase
extends ClusteringMatchingStrategyBase {
    private final MaxWeightMatching.IWeightProvider<TrackedFindingWithContext, TrackedFindingWithContext> weightProvider = new ExactMatchingWeightProvider();

    @Override
    protected void performMatching(List<TrackedFindingWithContext> oldFindings, List<TrackedFindingWithContext> newFindings, PairList<TrackedFindingWithContext, TrackedFindingWithContext> trackingResult) {
        PairList<TrackedFindingWithContext, TrackedFindingWithContext> result = LocationBasedClusteringMatchingStrategyBase.calculateTimeBoundedMatching(oldFindings, newFindings, this.weightProvider);
        result = LocationBasedClusteringMatchingStrategyBase.removeDuplicateIdsFromMatching(result);
        for (int i = 0; i < result.size(); ++i) {
            trackingResult.add((Object)((TrackedFindingWithContext)result.getFirst(i)), (Object)((TrackedFindingWithContext)result.getSecond(i)));
        }
    }

    private static class ExactMatchingWeightProvider
    implements MaxWeightMatching.IWeightProvider<TrackedFindingWithContext, TrackedFindingWithContext> {
        private static final double SAME_FILE_WEIGHT_BONUS = 1.0;

        private ExactMatchingWeightProvider() {
        }

        public double getConnectionWeight(TrackedFindingWithContext oldFinding, TrackedFindingWithContext newFinding) {
            String oldUniformPath;
            double weight = 1.0 / (double)(Math.abs(oldFinding.getStartLine() - newFinding.getStartLine()) + 1);
            TrackedElement peerElementForBranch = newFinding.getPeerElementForBranch(oldFinding.getBranchIndex());
            if (newFinding.getElement() != null && peerElementForBranch != null && (oldUniformPath = peerElementForBranch.getUniformPath()).equals(oldFinding.getUniformPath())) {
                weight += 1.0;
            }
            return weight;
        }
    }
}

