/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.user.User;
import com.teamscale.core.utils.TimestampedInteraction;
import com.teamscale.index.user.UserRecentInteractionIndex;
import java.util.List;
import java.util.OptionalLong;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="user-recently-interacted-branches", options={EStorageOption.BACKUP, EStorageOption.NO_ROLLBACK}, valueClasses={TimestampedInteraction.class})
public class UserRecentlyInteractedBranchesIndex
implements IProjectIndex,
IChangeTrackingIndex {
    public static final String INDEX_NAME = "user-recently-interacted-branches";
    private final UserRecentInteractionIndex<String> delegate;

    public UserRecentlyInteractedBranchesIndex(IStore store) {
        this.delegate = new UserRecentInteractionIndex(store);
    }

    public List<TimestampedInteraction<String>> getRecentlyInteractedBranchesWithTimestamps(User user) throws StorageException {
        return this.delegate.getRecentRelatedItems(user);
    }

    public List<String> getRecentlyInteractedBranches(User user) throws StorageException {
        return this.getRecentlyInteractedBranchesWithTimestamps(user).stream().map(TimestampedInteraction::identifier).toList();
    }

    public void registerInteractedBranch(String userName, String branchName, long timestamp) throws StorageException {
        this.delegate.registerItemInteraction(userName, (String)new TimestampedInteraction(Long.valueOf(timestamp), (Comparable)((Object)branchName)));
    }

    public void registerInteractedBranch(User user, String branchName, long timestamp) throws StorageException {
        this.registerInteractedBranch(user.getUsername(), branchName, timestamp);
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }

    public List<String> getRecentBranches(String userName) throws StorageException {
        return this.delegate.getRecentItems(userName);
    }
}

