/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.webhook;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.webhook.IWebhookApi;
import com.teamscale.index.webhook.WebhookPayload;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebhookSender.class);
    private static String webhookUrl = System.getenv("TEAMSCALE_WEBHOOK_URL");
    private static String bearerToken = System.getenv("TEAMSCALE_WEBHOOK_BEARER_TOKEN");

    public static void sendWebhook(ServerOptionIndex serverOptionIndex, WebhookPayload<?> payload) throws ServiceCallException {
        if (StringUtils.isEmpty((String)webhookUrl)) {
            LOGGER.debug("Webhook URL not configured (environment variable TEAMSCALE_WEBHOOK_URL). Skipping webhook.");
            return;
        }
        if (StringUtils.isEmpty((String)bearerToken)) {
            LOGGER.warn("Webhook URL is configured but bearer token is missing (environment variable TEAMSCALE_WEBHOOK_BEARER_TOKEN). Skipping webhook for security reasons.");
            return;
        }
        IWebhookApi api = (IWebhookApi)Retrofit.builder((String)webhookUrl).withBearerAuthentication(bearerToken).create(IWebhookApi.class);
        String baseUrl = WebhookSender.getBaseUrl(serverOptionIndex);
        api.sendWebhook(baseUrl, payload);
        LOGGER.info("Successfully sent {} webhook.", (Object)payload.eventType().getEventTypeName());
    }

    private static String getBaseUrl(ServerOptionIndex serverOptionIndex) {
        try {
            return BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to retrieve Teamscale base URL for webhook.", (Throwable)e);
            return null;
        }
    }

    @TestOnly
    public static void setWebhook(String webhookUrl, String bearerToken) {
        WebhookSender.webhookUrl = webhookUrl;
        WebhookSender.bearerToken = bearerToken;
    }
}

