/*
 * Decompiled with CFR 0.152.
 */
package org.sonar;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;

public class DurationStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(DurationStatistics.class);
    private static final String PROPERTY_KEY = "sonar.php.duration.statistics";
    private final Map<String, AtomicLong> statistics = new HashMap<String, AtomicLong>();
    private final boolean recordStat;

    public DurationStatistics(Configuration config) {
        this.recordStat = config.getBoolean(PROPERTY_KEY).orElse(false);
    }

    public <T> T time(String id, Supplier<T> supplier) {
        if (this.recordStat) {
            long startTime = System.nanoTime();
            T result = supplier.get();
            this.addRecord(id, System.nanoTime() - startTime);
            return result;
        }
        return supplier.get();
    }

    void addRecord(String id, long elapsedTime) {
        this.statistics.computeIfAbsent(id, key -> new AtomicLong(0L)).addAndGet(elapsedTime);
    }

    public void log() {
        if (this.recordStat) {
            StringBuilder out = new StringBuilder();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ROOT);
            symbols.setGroupingSeparator('\'');
            DecimalFormat format = new DecimalFormat("#,###", symbols);
            out.append("Duration Statistics");
            this.statistics.entrySet().stream().sorted((a, b) -> Long.compare(((AtomicLong)b.getValue()).get(), ((AtomicLong)a.getValue()).get())).forEach(e -> out.append(", ").append((String)e.getKey()).append(" ").append(format.format(((AtomicLong)e.getValue()).get() / 1000000L)).append(" ms"));
            String message = out.toString();
            LOG.info(message);
        }
    }
}

