/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S127")
public class ForLoopCounterChangedCheck
extends PHPVisitorCheck {
    public static final String KEY = "S127";
    private static final String MESSAGE = "Refactor the code to avoid updating the loop counter \"%s\" within the loop body.";
    private static final Tree.Kind[] INCREMENT_DECREMENT = new Tree.Kind[]{Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT};
    private Deque<Set<String>> counterStack = new ArrayDeque<Set<String>>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.counterStack.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree forStatement) {
        this.visitAll(forStatement.init());
        this.visitAll(forStatement.condition());
        this.visitAll(forStatement.update());
        HashSet<String> newCounters = new HashSet<String>();
        if (!this.counterStack.isEmpty()) {
            newCounters.addAll((Collection)this.counterStack.peek());
        }
        newCounters.addAll(ForLoopCounterChangedCheck.getCounterNames(forStatement));
        this.counterStack.push(newCounters);
        this.visitAll(forStatement.statements());
        this.counterStack.pop();
    }

    private void visitAll(Iterable<? extends Tree> trees) {
        for (Tree tree : trees) {
            tree.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.checkVariable(tree.variable());
        super.visitAssignmentExpression(tree);
    }

    @Override
    public void visitPrefixExpression(UnaryExpressionTree tree) {
        this.checkUnaryExpressionTree(tree);
        super.visitPrefixExpression(tree);
    }

    @Override
    public void visitPostfixExpression(UnaryExpressionTree tree) {
        this.checkUnaryExpressionTree(tree);
        super.visitPostfixExpression(tree);
    }

    private void checkUnaryExpressionTree(UnaryExpressionTree tree) {
        if (tree.is(INCREMENT_DECREMENT)) {
            this.checkVariable(tree.expression());
        }
    }

    private void checkVariable(ExpressionTree variable) {
        if (!this.counterStack.isEmpty()) {
            String variableName = variable.toString();
            if (this.counterStack.peek().contains(variableName)) {
                this.context().newIssue(this, variable, String.format(MESSAGE, variableName));
            }
        }
    }

    private static Set<String> getCounterNames(ForStatementTree forStatement) {
        HashSet<String> counterNames = new HashSet<String>();
        for (ExpressionTree initExpression : forStatement.init()) {
            if (initExpression.is(Tree.Kind.ASSIGNMENT)) {
                counterNames.add(((AssignmentExpressionTree)initExpression).variable().toString());
                continue;
            }
            if (!initExpression.is(INCREMENT_DECREMENT)) continue;
            counterNames.add(((UnaryExpressionTree)initExpression).expression().toString());
        }
        return counterNames;
    }
}

