/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.GlobalStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2011")
public class GlobalKeywordAndArrayUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2011";
    private static final String MESSAGE = "Pass this global variable to the function as a parameter rather than accessing it directly.";
    private static final String GLOBAL_IDENTIFIER = "$GLOBALS";

    @Override
    public void visitGlobalStatement(GlobalStatementTree tree) {
        super.visitGlobalStatement(tree);
        this.raiseIssue(tree);
    }

    @Override
    public void visitArrayAccess(ArrayAccessTree tree) {
        String name;
        super.visitArrayAccess(tree);
        ExpressionTree object = tree.object();
        if (object.is(Tree.Kind.VARIABLE_IDENTIFIER) && (name = ((VariableIdentifierTree)object).variableExpression().text()).equals(GLOBAL_IDENTIFIER)) {
            this.raiseIssue(tree);
        }
    }

    private void raiseIssue(Tree tree) {
        this.context().newIssue(this, tree, MESSAGE);
    }
}

