/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1142")
public class TooManyReturnCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1142";
    private static final String MESSAGE = "This %s has %d returns, which is more than the %d allowed.";
    private static final String SECONDARY_MESSAGE = "\"return\" statement.";
    private static final int DEFAULT = 3;
    private final Deque<Deque<SyntaxToken>> returnStatementCounter = new ArrayDeque<Deque<SyntaxToken>>();
    @RuleProperty(key="max", defaultValue="3")
    int max = 3;

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        boolean isGlobalScope = this.returnStatementCounter.isEmpty();
        if (!isGlobalScope) {
            this.returnStatementCounter.peek().push(tree.returnToken());
        }
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.returnStatementCounter.clear();
        super.visitScript(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterFunction();
        super.visitFunctionDeclaration(tree);
        this.leaveFunction(tree);
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterFunction();
        super.visitFunctionExpression(tree);
        this.leaveFunction(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterFunction();
        super.visitMethodDeclaration(tree);
        this.leaveFunction(tree);
    }

    private void enterFunction() {
        this.returnStatementCounter.push(new ArrayDeque());
    }

    private void leaveFunction(FunctionTree tree) {
        Deque<SyntaxToken> thisFunctionReturns = this.returnStatementCounter.pop();
        if (thisFunctionReturns.size() > this.max) {
            PreciseIssue issue = this.getIssue(tree, thisFunctionReturns.size());
            thisFunctionReturns.forEach(returnToken -> issue.secondary((Tree)returnToken, SECONDARY_MESSAGE));
        }
    }

    private PreciseIssue getIssue(FunctionTree functionTree, int returns) {
        Tree tree;
        String type = "function";
        if (functionTree.is(Tree.Kind.METHOD_DECLARATION)) {
            type = "method";
            tree = ((MethodDeclarationTree)functionTree).name();
        } else {
            tree = functionTree.is(Tree.Kind.FUNCTION_DECLARATION) ? ((FunctionDeclarationTree)functionTree).name() : functionTree.functionToken();
        }
        String message = String.format(MESSAGE, type, returns, this.max);
        return this.context().newIssue(this, tree, message);
    }
}

