/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;

@Rule(key="S6347")
public class WordPressLateConfigCheck
extends WordPressConfigVisitor {
    private static final String MESSAGE = "Configuration options at this location will not be taken into account.";
    private boolean endOfConfig;

    @Override
    public void visitScript(ScriptTree tree) {
        this.endOfConfig = false;
        super.visitScript(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        this.checkEndOfConfig(tree);
        super.visitFunctionCall(tree);
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        if (this.endOfConfig) {
            this.newIssue(config, MESSAGE);
        }
    }

    private void checkEndOfConfig(FunctionCallTree tree) {
        if ("require_once".equalsIgnoreCase(CheckUtils.functionName(tree)) && WordPressLateConfigCheck.isSettingsInclusion(tree)) {
            this.endOfConfig = true;
        }
    }

    private static boolean isSettingsInclusion(FunctionCallTree tree) {
        return CheckUtils.argument(tree, "", 0).map(CallArgumentTree::value).map(WordPressLateConfigCheck::extractRelativePath).filter(a -> CheckUtils.isStringLiteralWithValue(a, "wp-settings.php")).isPresent();
    }

    private static ExpressionTree extractRelativePath(ExpressionTree argument) {
        if (argument.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            argument = ((ParenthesisedExpressionTree)argument).expression();
        }
        return argument.is(Tree.Kind.CONCATENATION) ? ((BinaryExpressionTree)argument).rightOperand() : null;
    }
}

