/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.visitors;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.LocationInFile;

public class IssueLocation {
    @Nullable
    private final String filePath;
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;
    private final String message;

    private IssueLocation(SyntaxToken firstToken, SyntaxToken lastToken, @Nullable String message) {
        this.filePath = null;
        this.startLine = firstToken.line();
        this.startLineOffset = firstToken.column();
        this.endLine = lastToken.endLine();
        this.endLineOffset = lastToken.endColumn();
        this.message = message;
    }

    public IssueLocation(Tree tree, @Nullable String message) {
        this(tree, tree, message);
    }

    public IssueLocation(Tree startTree, Tree endTree, @Nullable String message) {
        this(((PHPTree)startTree).getFirstToken(), ((PHPTree)endTree).getLastToken(), message);
    }

    public IssueLocation(LocationInFile locationInFile, @Nullable String message) {
        this.filePath = locationInFile.filePath();
        this.startLine = locationInFile.startLine();
        this.startLineOffset = locationInFile.startLineOffset();
        this.endLine = locationInFile.endLine();
        this.endLineOffset = locationInFile.endLineOffset();
        this.message = message;
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }

    @Nullable
    public String message() {
        return this.message;
    }

    @CheckForNull
    public String filePath() {
        return this.filePath;
    }
}

