/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class AbapConditionalStatementsCheckBase
extends CheckImplementationBase {
    private static final Set<String> CONDITION_STATEMENT_SUBTYPE_NAMES = Set.of("if", "elseif", "case", "cond", "check", "while", "do");
    public static final Set<String> DIRECT_CONDITION_STATEMENTS_SUBTYPE_NAMES = Set.of("if", "elseif", "while", "check");

    public void execute() throws CheckException {
        List entities = ShallowEntityTraversalUtils.selectEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), entity -> entity.getType() == EShallowEntityType.STATEMENT && CONDITION_STATEMENT_SUBTYPE_NAMES.contains(entity.getSubtype()));
        for (ShallowEntity entity2 : entities) {
            if (DIRECT_CONDITION_STATEMENTS_SUBTYPE_NAMES.contains(entity2.getSubtype())) {
                this.checkDirectConditionStatement(entity2);
                continue;
            }
            if (entity2.getSubtype().equals("case")) {
                this.checkCaseWhenStatements(entity2);
                continue;
            }
            if (entity2.getSubtype().equals("cond")) {
                this.checkCondWhenStatements(entity2);
                continue;
            }
            if (!entity2.getSubtype().equals("do")) continue;
            this.checkDoStatement(entity2);
        }
    }

    abstract boolean checkCondition(List<IToken> var1);

    abstract void buildFinding(List<IToken> var1);

    protected void checkDirectConditionStatement(ShallowEntity conditionEntity) {
        List conditionTokens = TokenStreamUtils.tokensFromTo((List)conditionEntity.ownStartTokens(), (int)1, (ETokenType[])new ETokenType[]{ETokenType.DOT});
        if (conditionTokens.isEmpty()) {
            return;
        }
        if (this.checkCondition(conditionTokens)) {
            this.buildFinding((List<IToken>)conditionEntity.ownStartTokens());
        }
    }

    protected void checkDoStatement(ShallowEntity doEntity) {
        UnmodifiableList tokens = doEntity.ownStartTokens();
        List conditionStatementTokens = TokenStreamUtils.tokensFromTo((List)tokens, (int)1, (ETokenType[])new ETokenType[]{ETokenType.TIMES});
        if (conditionStatementTokens.isEmpty()) {
            return;
        }
        if (this.checkCondition(conditionStatementTokens)) {
            this.buildFinding((List<IToken>)doEntity.ownStartTokens());
        }
    }

    protected void checkCaseWhenStatements(ShallowEntity caseEntity) {
        List caseOperandTokens = TokenStreamUtils.tokensFromTo((List)caseEntity.ownStartTokens(), (int)1, (ETokenType[])new ETokenType[]{ETokenType.DOT});
        if (caseOperandTokens.isEmpty()) {
            return;
        }
        if (this.checkCondition(caseOperandTokens)) {
            this.buildFinding((List<IToken>)caseEntity.ownStartTokens());
        }
        for (ShallowEntity child : caseEntity.getChildren()) {
            if (child.getType() != EShallowEntityType.META || !child.getSubtype().equals("when")) continue;
            this.checkDirectConditionStatement(child);
        }
    }

    protected void checkCondWhenStatements(ShallowEntity conditionEntity) {
        List<List<IToken>> whenStatements = AbapConditionalStatementsCheckBase.getWhenStatementsExpressions((UnmodifiableList<IToken>)conditionEntity.ownStartTokens());
        if (whenStatements.isEmpty()) {
            return;
        }
        for (List<IToken> whenStatement : whenStatements) {
            if (!this.checkCondition(whenStatement)) continue;
            this.buildFinding(whenStatement);
        }
    }

    private static List<List<IToken>> getWhenStatementsExpressions(UnmodifiableList<IToken> tokens) {
        List whenTokenIndices = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ETokenType.WHEN);
        if (whenTokenIndices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<IToken>> whenStatements = new ArrayList<List<IToken>>();
        Iterator iterator = whenTokenIndices.iterator();
        while (iterator.hasNext()) {
            int whenTokenIndex = (Integer)iterator.next();
            whenStatements.add(TokenStreamUtils.tokensFromTo(tokens, (int)whenTokenIndex, (ETokenType[])new ETokenType[]{ETokenType.THEN}));
        }
        return whenStatements;
    }
}

