/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class FunctionCallCheckBase
extends CheckImplementationBase {
    private Set<String> relevantFunctionNamesInUppercase;

    protected abstract Set<String> getRelevantFunctionNames();

    protected abstract String buildFindingsMessage(String var1);

    public void initialize() throws CheckException {
        this.relevantFunctionNamesInUppercase = this.getRelevantFunctionNames().stream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"call".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (!FunctionCallCheckBase.isFunctionCall((List<IToken>)tokens)) {
            return;
        }
        String functionName = ((IToken)tokens.get(2)).getText().replaceAll("'|`", "");
        if (this.relevantFunctionNamesInUppercase.contains(functionName.toUpperCase())) {
            this.buildFinding(this.buildFindingsMessage(functionName), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private static boolean isFunctionCall(List<IToken> tokens) {
        return TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION, ETokenType.CHARACTER_LITERAL}) || TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION, ETokenType.STRING_LITERAL});
    }
}

