/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-do-not-put-multiple-statements-in-lambda", languages={ELanguage.JAVA, ELanguage.JAVASCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotPutMultipleStatementsInLambdaCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum statements in Lambda", description="Maximum statement count in a Lambda")
    private static int maxNumberOfAllowedStatements = 1;
    @CheckOption(name="Disallow nested Lambdas", description="If enabled, create findings for nested lambdas regardless of the number of statements.")
    private boolean disallowNestedLambdas = true;
    private static final String FINDING_MESSAGE = "Do not put more than %d statements inside a lambda";
    private static final String NESTED_LAMBDA_FINDING_MESSAGE = "Avoid nested lambda expression";

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!ShallowParsingUtils.isLambdaMethod((ShallowEntity)method)) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (DoNotPutMultipleStatementsInLambdaCheck.isMultiStatementLambda(entity)) {
            this.buildFinding(String.format(FINDING_MESSAGE, maxNumberOfAllowedStatements), this.buildLocation().forEntity(entity)).createAndStore();
        }
        this.checkNestedLambda(entity);
    }

    private static boolean isMultiStatementLambda(ShallowEntity entity) {
        while (entity.getSubtype().equals("lambda") || entity.getSubtype().equals("lambda expression")) {
            if (!entity.hasChildren()) {
                return false;
            }
            if (entity.getChildren().size() > maxNumberOfAllowedStatements) {
                return true;
            }
            entity = (ShallowEntity)entity.getChildren().get(0);
        }
        return entity.getChildren().size() > maxNumberOfAllowedStatements;
    }

    private void checkNestedLambda(ShallowEntity entity) {
        if (!this.disallowNestedLambdas) {
            return;
        }
        while (entity.getParent() != null) {
            if (ShallowParsingUtils.isLambdaMethod((ShallowEntity)entity.getParent())) {
                this.buildFinding(NESTED_LAMBDA_FINDING_MESSAGE, this.buildLocation().forEntity(entity.getParent())).createAndStore();
                return;
            }
            entity = entity.getParent();
        }
    }
}

