/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.c.IfDirectivePreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-endif-directive-comment-check", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.CS, ELanguage.SWIFT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class EndifDirectiveCommentCheck
extends CheckImplementationBase {
    private static final Pattern COMMENT_MARKER = Pattern.compile("[/*]");

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED;
    }

    public void execute() throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(this.getCodeViewOption());
        Stack<String> conditions = new Stack<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            IToken token = (IToken)tokens.get(i);
            if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE) continue;
            if (IfDirectivePreprocessor.isIfDirective((IToken)token)) {
                conditions.push(EndifDirectiveCommentCheck.getCondition((List<IToken>)tokens, i));
                continue;
            }
            if (!IfDirectivePreprocessor.isEndIfDirective((IToken)token)) continue;
            String condition = (String)conditions.pop();
            this.checkCommentAndCreateFinding((List<IToken>)tokens, i, condition);
        }
    }

    private void checkCommentAndCreateFinding(List<IToken> tokens, int startIndex, String condition) {
        if (tokens.size() <= startIndex + 1 || tokens.get(startIndex + 1).getType().getTokenClass() != ETokenType.ETokenClass.COMMENT || tokens.get(startIndex + 1).getLineNumber() != tokens.get(startIndex).getLineNumber()) {
            this.buildFinding("The #endif directive line is missing a comment. Expected: " + MarkupUtils.formatAsSourceCode((String)("// " + condition)) + " after #endif, but was: empty.", this.buildLocation().forLine(tokens.get(startIndex).getLineNumber() + 1)).createAndStore();
        } else if (tokens.size() > startIndex + 1 && !EndifDirectiveCommentCheck.isCorrectCommentStyle(condition, tokens.get(startIndex + 1).getText())) {
            this.buildFinding("The comment on #endif directive line has the wrong format. Expected: " + MarkupUtils.formatAsSourceCode((String)("// " + condition)) + " after #endif, but was: " + MarkupUtils.formatAsSourceCode((String)tokens.get(startIndex + 1).getText()) + ".", this.buildLocation().forToken(tokens.get(startIndex + 1))).createAndStore();
        }
    }

    private static String getCondition(List<IToken> tokens, int index) {
        if (tokens.get(index).getLanguage() == ELanguage.SWIFT) {
            int indexEOL = TokenStreamUtils.firstTokenMatching(tokens, (int)index, (ITokenMatcher)ETokenType.EOL);
            return TokenStreamTextUtils.concatTokenTexts(tokens.subList(index + 1, indexEOL), (String)" ");
        }
        return TokenStreamTextUtils.concatTokenTexts((List)IfDirectivePreprocessor.extractCondition((IToken)tokens.get(index)), (String)" ");
    }

    private static boolean isCorrectCommentStyle(String condition, String endIfComment) {
        boolean isEndifCommentTraditional = endIfComment.startsWith("/*");
        endIfComment = StringUtils.removeWhitespace((String)COMMENT_MARKER.matcher(endIfComment).replaceAll(""));
        condition = StringUtils.removeWhitespace((String)condition);
        String macroName = StringUtils.between((String)condition, (String)"(", (String)")");
        if (endIfComment.equals(condition) || endIfComment.equals("#if" + condition) || endIfComment.equals(macroName) && isEndifCommentTraditional) {
            return true;
        }
        if (condition.startsWith("!") && macroName != null) {
            String notCondition = "not" + macroName;
            String exclamationCondition = "#if!" + macroName;
            return endIfComment.equals(macroName) || endIfComment.equals(notCondition) || endIfComment.equals(exclamationCondition);
        }
        return false;
    }
}

