/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.base.TopLevelTypeCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;

@Check(id="cqse-cpp-multiple-top-level-classes", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CppMultipleTopLevelClassesCheck
extends TopLevelTypeCheckBase {
    protected boolean isTopLevelType(ShallowEntity typeEntity) {
        return LanguageFeatureParser.CPP.isTopLevelClass(typeEntity);
    }

    protected void analyzeTopLevelTypes(List<ShallowEntity> topLevelTypeEntities) throws CheckException {
        if (topLevelTypeEntities.size() > 1) {
            for (ShallowEntity entity : topLevelTypeEntities) {
                this.buildFinding("Multiple top-level class definitions in one file", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            }
        }
    }
}

