/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.cpp.HeaderFileCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;

@Check(id="cqse-method-definition-in-header", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OBJECTIVE_CPP, ELanguage.OBJECTIVE_C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MethodDefinitionInHeaderCheck
extends HeaderFileCheckBase {
    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    @Override
    public void executeHeaderCheck() throws CheckException {
        List topLevelMethods = this.context.getRootEntity(this.getCodeViewOption()).getChildrenOfType(EShallowEntityType.METHOD);
        List<ShallowEntity> wrongFunctions = topLevelMethods.stream().filter(entity -> "function".equals(entity.getSubtype())).filter(entity -> !LanguageFeatureParser.CPP.isInline(entity)).filter(entity -> !LanguageFeatureParser.CPP.isConstExpr(entity)).filter(entity -> !LanguageFeatureParser.CPP.isTemplated(entity)).toList();
        for (ShallowEntity entity2 : wrongFunctions) {
            this.buildFinding("`" + entity2.getName() + "` should not be defined in the header", this.buildLocation().forEntity(entity2)).createAndStore();
        }
    }
}

