/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.clang;

import eu.cqse.check.cpp.clang.base.ClangCursorVisitorCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.util.clang.ClangUtils;
import eu.cqse.check.util.clang.misra.EEssentialType;
import eu.cqse.check.util.clang.visitors.FindingCollectingClangCursorVisitorBase;
import eu.cqse.clang.CXChildVisitResult;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXCursorKind;
import eu.cqse.clang.CXString;
import eu.cqse.clang.CXType;
import eu.cqse.clang.Clang;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-composite-expression-assignment-type", languages={ELanguage.C}, parameters={ECheckParameter.CLANG})
public class CompositeExpressionAssignmentTypeCheck
extends ClangCursorVisitorCheckBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CLANG_BUILTIN_FN_TYPE = "<builtin fn type>";

    @Override
    protected FindingCollectingClangCursorVisitorBase createVisitor(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, String uniformPath, String fileText) {
        return new CompositeExpressionAssignmentTypeCheckVisitor(translationUnit, uniformPath, fileText);
    }

    private static class CompositeExpressionAssignmentTypeCheckVisitor
    extends FindingCollectingClangCursorVisitorBase {
        private CompositeExpressionAssignmentTypeCheckVisitor(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, String uniformPath, String fileText) {
            super(translationUnit, uniformPath, fileText);
        }

        public CXChildVisitResult visit(CXCursor cursor, CXCursor parent) {
            this.findAssignmentToWiderType(cursor);
            this.findCallWithWiderParameterType(cursor);
            return CXChildVisitResult.CXChildVisit_Recurse;
        }

        private void findCallWithWiderParameterType(CXCursor cursor) {
            boolean functionIsVariadic;
            if (Clang.clang_getCursorKind((CXCursor)cursor) != CXCursorKind.CXCursor_CallExpr) {
                return;
            }
            List children = ClangUtils.getDirectChildren((CXCursor)cursor);
            if (children.isEmpty()) {
                return;
            }
            Optional<CXType> resolvedFunctionType = CompositeExpressionAssignmentTypeCheckVisitor.resolveFunctionType((CXCursor)children.get(0));
            List<CXCursor> actualParameters = children.subList(1, children.size());
            if (!resolvedFunctionType.isPresent() || CompositeExpressionAssignmentTypeCheck.CLANG_BUILTIN_FN_TYPE.equals(Clang.clang_getCString((CXString)Clang.clang_getTypeSpelling((CXType)resolvedFunctionType.get()))) || actualParameters.isEmpty()) {
                return;
            }
            int numFormalParameters = Clang.clang_getNumArgTypes((CXType)resolvedFunctionType.get());
            boolean bl = functionIsVariadic = 1L == Clang.clang_isFunctionTypeVariadic((CXType)resolvedFunctionType.get());
            if (!this.checkNumberOfParametersMatch(cursor, actualParameters, numFormalParameters, functionIsVariadic)) {
                return;
            }
            List<Integer> parameterIndicesWithWiderType = CompositeExpressionAssignmentTypeCheckVisitor.getParameterIndicesWithWiderType(resolvedFunctionType.get(), actualParameters, numFormalParameters, functionIsVariadic);
            if (parameterIndicesWithWiderType.isEmpty()) {
                return;
            }
            String message = CompositeExpressionAssignmentTypeCheckVisitor.buildParameterFindingMessage(parameterIndicesWithWiderType);
            Optional cursorLocation = ClangUtils.createTextRegionLocation((CXCursor)cursor);
            cursorLocation.ifPresent(textRegionLocation -> this.reportFinding((TextRegionLocation)textRegionLocation, message));
        }

        private boolean checkNumberOfParametersMatch(CXCursor cursor, List<CXCursor> actualParameters, int numFormalParameters, boolean functionIsVariadic) {
            if (numFormalParameters == 0) {
                return false;
            }
            if (functionIsVariadic && actualParameters.size() < numFormalParameters) {
                String startLine = ClangUtils.createTextRegionLocation((CXCursor)cursor).map(loc -> String.valueOf(loc.getRawStartLine())).orElse("?");
                LOGGER.warn("Found inconsistent number of parameters in (variadic) function call in " + this.uniformPath + ":" + startLine + " " + numFormalParameters + " >" + actualParameters.size());
                return false;
            }
            if (!functionIsVariadic && actualParameters.size() != numFormalParameters) {
                String startLine = ClangUtils.createTextRegionLocation((CXCursor)cursor).map(loc -> String.valueOf(loc.getRawStartLine())).orElse("?");
                LOGGER.warn("Found inconsistent number of parameters in function call in " + this.uniformPath + ":" + startLine + " " + numFormalParameters + " vs " + actualParameters.size());
                return false;
            }
            return true;
        }

        private static List<Integer> getParameterIndicesWithWiderType(CXType resolvedFunctionType, List<CXCursor> actualParameters, int numFormalParameters, boolean isVariadicFunction) {
            ArrayList<Integer> parameterIndicesWithWiderType = new ArrayList<Integer>(numFormalParameters);
            for (int i = 0; i < actualParameters.size(); ++i) {
                CXType formalParameterType = !isVariadicFunction || i < numFormalParameters ? ClangUtils.resolveTypedefs((CXType)Clang.clang_getArgType((CXType)resolvedFunctionType, (long)i)) : ClangUtils.resolveTypedefs((CXType)Clang.clang_getArgType((CXType)resolvedFunctionType, (long)(numFormalParameters - 1)));
                if (!CompositeExpressionAssignmentTypeCheckVisitor.isCompositeExpression(actualParameters.get(i)) || !CompositeExpressionAssignmentTypeCheckVisitor.formalParameterIsEssentiallyWiderThanActualParameter(formalParameterType, actualParameters.get(i))) continue;
                parameterIndicesWithWiderType.add(i);
            }
            return parameterIndicesWithWiderType;
        }

        private static boolean formalParameterIsEssentiallyWiderThanActualParameter(CXType formalParameterType, CXCursor actualParameter) {
            Optional formalParameterEssentialType = EEssentialType.fromClangResolvedType((CXType)formalParameterType);
            Optional actualParameterEssentialType = EEssentialType.getEssentialTypeOfCursor((CXCursor)actualParameter);
            return formalParameterEssentialType.isPresent() && actualParameterEssentialType.isPresent() && ((EEssentialType)formalParameterEssentialType.get()).isWiderThan((EEssentialType)actualParameterEssentialType.get());
        }

        private static String buildParameterFindingMessage(List<Integer> findingIndices) {
            return StringUtils.pluralize((String)"Assignment to wider essential parameter type in parameter", (int)findingIndices.size()) + " " + findingIndices.stream().map(x -> String.valueOf(x + 1)).collect(Collectors.joining(", "));
        }

        private static Optional<CXType> resolveFunctionType(CXCursor functionCallNameCursor) {
            CXCursor functionNameCursor = (CXCursor)CollectionUtils.getAny((Iterable)ClangUtils.findChildrenWithKindRecursively((CXCursor)functionCallNameCursor, (CXCursorKind)CXCursorKind.CXCursor_DeclRefExpr));
            if (functionNameCursor == null) {
                return Optional.empty();
            }
            return Optional.of(ClangUtils.resolveTypedefs((CXType)Clang.clang_getCursorType((CXCursor)functionNameCursor)));
        }

        private void findAssignmentToWiderType(CXCursor cursor) {
            if (Clang.clang_getCursorKind((CXCursor)cursor) != CXCursorKind.CXCursor_BinaryOperator || !ClangUtils.getOperatorText((CXCursor)cursor, (String)this.fileText).equals(Optional.of("="))) {
                return;
            }
            List children = ClangUtils.getDirectChildren((CXCursor)cursor);
            CXCursor lhs = (CXCursor)children.get(0);
            CXCursor rhs = (CXCursor)children.get(1);
            if (!CompositeExpressionAssignmentTypeCheckVisitor.isCompositeExpression(rhs)) {
                return;
            }
            Optional lhsEssentialType = EEssentialType.getEssentialTypeOfCursor((CXCursor)lhs);
            Optional rhsEssentialType = EEssentialType.getEssentialTypeOfCursor((CXCursor)rhs);
            if (lhsEssentialType.isPresent() && rhsEssentialType.isPresent() && ((EEssentialType)lhsEssentialType.get()).isWiderThan((EEssentialType)rhsEssentialType.get())) {
                Optional cursorLocation = ClangUtils.createTextRegionLocation((CXCursor)cursor);
                Optional nameOrExpression = ClangUtils.getCompleteNodeText((CXCursor)lhs, (String)this.fileText);
                if (cursorLocation.isPresent() && nameOrExpression.isPresent()) {
                    this.reportFinding((TextRegionLocation)cursorLocation.get(), "Assignment to wider essential type " + StringUtils.truncateWithThreeDots((String)((String)nameOrExpression.get()), (int)8));
                }
            }
        }

        private static boolean isCompositeExpression(CXCursor cursor) {
            if (cursor.getKind() == CXCursorKind.CXCursor_BinaryOperator) {
                return true;
            }
            return !ClangUtils.findChildrenWithKindRecursively((CXCursor)cursor, (CXCursorKind)CXCursorKind.CXCursor_BinaryOperator).isEmpty();
        }
    }
}

